/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.stream.OrcInputStream;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface StripeMetadataSource {
    public Slice getStripeFooterSlice(OrcDataSource var1, StripeReader.StripeId var2, long var3, int var5, boolean var6, long var7) throws IOException;

    public Map<StreamId, OrcDataSourceInput> getInputs(OrcDataSource var1, StripeReader.StripeId var2, Map<StreamId, DiskRange> var3, boolean var4, long var5) throws IOException;

    public List<RowGroupIndex> getRowIndexes(MetadataReader var1, PostScript.HiveWriterVersion var2, StripeReader.StripeId var3, StreamId var4, OrcInputStream var5, List<HiveBloomFilter> var6, RuntimeStats var7, long var8) throws IOException;

    public static class CacheableRowGroupIndices {
        private final List<RowGroupIndex> rowGroupIndices;
        private final long fileModificationTime;

        public CacheableRowGroupIndices(List<RowGroupIndex> rowGroupIndices, long fileModificationTime) {
            this.rowGroupIndices = Objects.requireNonNull(rowGroupIndices, "rowGroupIndices is null");
            this.fileModificationTime = fileModificationTime;
        }

        public List<RowGroupIndex> getRowGroupIndices() {
            return this.rowGroupIndices;
        }

        public long getFileModificationTime() {
            return this.fileModificationTime;
        }
    }

    public static class CacheableSlice {
        private final Slice slice;
        private final long fileModificationTime;

        CacheableSlice(Slice slice, long fileModificationTime) {
            this.slice = Objects.requireNonNull(slice, "slice is null");
            this.fileModificationTime = fileModificationTime;
        }

        public Slice getSlice() {
            return this.slice;
        }

        public long getFileModificationTime() {
            return this.fileModificationTime;
        }
    }
}

