/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.StreamDescriptorFactory;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class StreamDescriptor {
    private final StreamDescriptorFactory.AllStreams allStreams;
    private final int streamId;
    private final int sequence;

    public StreamDescriptor(int streamId, StreamDescriptorFactory.AllStreams allStreams) {
        this(streamId, 0, allStreams);
    }

    public StreamDescriptor(int streamId, int sequence, StreamDescriptorFactory.AllStreams allStreams) {
        this.streamId = streamId;
        this.sequence = sequence;
        this.allStreams = Objects.requireNonNull(allStreams, "allStreams is null");
    }

    public StreamDescriptor duplicate(int sequence) {
        return new StreamDescriptor(this.streamId, sequence, this.allStreams);
    }

    public String getStreamName() {
        return this.getStreamProperty().getStreamName();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public OrcType.OrcTypeKind getOrcTypeKind() {
        return this.getOrcType().getOrcTypeKind();
    }

    public OrcType getOrcType() {
        return this.getStreamProperty().getOrcType();
    }

    public String getFieldName() {
        return this.getStreamProperty().getFieldName();
    }

    public OrcDataSourceId getOrcDataSourceId() {
        return this.getOrcDataSource().getId();
    }

    public OrcDataSource getOrcDataSource() {
        return this.allStreams.getOrcDataSource();
    }

    public List<StreamDescriptor> getNestedStreams() {
        List<Integer> nestedStreamIds = this.getStreamProperty().getNestedStreamIds();
        if (nestedStreamIds.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder nestedStreamsBuilder = ImmutableList.builderWithExpectedSize((int)nestedStreamIds.size());
        for (int nestedStreamId : nestedStreamIds) {
            nestedStreamsBuilder.add((Object)new StreamDescriptor(nestedStreamId, this.sequence, this.allStreams));
        }
        return nestedStreamsBuilder.build();
    }

    private StreamDescriptorFactory.StreamProperty getStreamProperty() {
        return this.allStreams.getStreamProperty(this.streamId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("streamName", (Object)this.getStreamName()).add("streamId", this.streamId).add("sequence", this.sequence).add("orcType", (Object)this.getOrcType()).add("dataSource", (Object)this.getOrcDataSourceId()).toString();
    }
}

