/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class StorageStripeMetadataSource
implements StripeMetadataSource {
    @Override
    public Slice getStripeFooterSlice(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, long footerOffset, int footerLength, boolean cacheable, long fileModificationTime) throws IOException {
        byte[] tailBuffer = new byte[footerLength];
        orcDataSource.readFully(footerOffset, tailBuffer);
        return Slices.wrappedBuffer((byte[])tailBuffer);
    }

    @Override
    public Map<StreamId, OrcDataSourceInput> getInputs(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, Map<StreamId, DiskRange> diskRanges, boolean cacheable, long fileModificationTime) throws IOException {
        ImmutableMap.Builder diskRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            diskRangesBuilder.put((Object)entry.getKey(), (Object)new DiskRange(stripeId.getOffset() + diskRange.getOffset(), diskRange.getLength()));
        }
        diskRanges = diskRangesBuilder.build();
        return orcDataSource.readFully(diskRanges);
    }

    @Override
    public List<RowGroupIndex> getRowIndexes(MetadataReader metadataReader, PostScript.HiveWriterVersion hiveWriterVersion, StripeReader.StripeId stripeId, StreamId streamId, OrcInputStream inputStream, List<HiveBloomFilter> bloomFilters, RuntimeStats runtimeStats, long fileModificationTime) throws IOException {
        return metadataReader.readRowIndexes(hiveWriterVersion, inputStream, bloomFilters);
    }
}

