/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcReaderOptions;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;

public class OrcRecordReaderOptions {
    private final DataSize maxMergeDistance;
    private final DataSize tinyStripeThreshold;
    private final DataSize maxBlockSize;
    private final boolean mapNullKeysEnabled;
    private final boolean appendRowNumber;
    private final long maxSliceSize;
    private final boolean resetAllReaders;

    public OrcRecordReaderOptions(OrcReaderOptions options) {
        this(options.getMaxMergeDistance(), options.getTinyStripeThreshold(), options.getMaxBlockSize(), options.mapNullKeysEnabled(), options.appendRowNumber(), options.getMaxSliceSize(), options.isResetAllReaders());
    }

    public OrcRecordReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean mapNullKeysEnabled, boolean appendRowNumber, DataSize maxSliceSize, boolean resetAllReaders) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.mapNullKeysEnabled = mapNullKeysEnabled;
        this.appendRowNumber = appendRowNumber;
        Preconditions.checkArgument((maxSliceSize.toBytes() < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"maxSliceSize cannot be larger than Integer.MAX_VALUE");
        Preconditions.checkArgument((maxSliceSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSliceSize must be positive");
        this.maxSliceSize = maxSliceSize.toBytes();
        this.resetAllReaders = resetAllReaders;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public DataSize getTinyStripeThreshold() {
        return this.tinyStripeThreshold;
    }

    public boolean mapNullKeysEnabled() {
        return this.mapNullKeysEnabled;
    }

    public boolean appendRowNumber() {
        return this.appendRowNumber;
    }

    public long getMaxSliceSize() {
        return this.maxSliceSize;
    }

    public boolean isResetAllReaders() {
        return this.resetAllReaders;
    }
}

