/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.EncryptionLibrary;
import java.util.Objects;

public class DwrfDataEncryptor {
    private final byte[] keyMetadata;
    private final EncryptionLibrary encryptionLibrary;

    public DwrfDataEncryptor(byte[] keyMetadata, EncryptionLibrary encryptionLibrary) {
        this.keyMetadata = Objects.requireNonNull(keyMetadata, "keyMetadata is null");
        this.encryptionLibrary = Objects.requireNonNull(encryptionLibrary, "encryptionLibrary is null");
    }

    public byte[] decrypt(byte[] input, int offset, int length) {
        return this.encryptionLibrary.decryptData(this.keyMetadata, input, offset, length);
    }

    public byte[] encrypt(byte[] input, int offset, int length) {
        return this.encryptionLibrary.encryptData(this.keyMetadata, input, offset, length);
    }
}

