/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DwrfAwareStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.metadata.DwrfStripeCache;
import java.util.Objects;
import java.util.Optional;

public class DwrfAwareStripeMetadataSourceFactory
implements StripeMetadataSourceFactory {
    private final StripeMetadataSourceFactory delegateFactory;

    public DwrfAwareStripeMetadataSourceFactory(StripeMetadataSourceFactory delegateFactory) {
        this.delegateFactory = Objects.requireNonNull(delegateFactory, "delegateFactory is null");
    }

    @Override
    public StripeMetadataSource create(Optional<DwrfStripeCache> dwrfStripeCache) {
        StripeMetadataSource delegate = Objects.requireNonNull(this.delegateFactory.create(dwrfStripeCache), "created delegate is null");
        if (dwrfStripeCache.isPresent()) {
            return new DwrfAwareStripeMetadataSource(delegate, dwrfStripeCache.get());
        }
        return delegate;
    }
}

