/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.DwrfStripeCache;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DwrfAwareStripeMetadataSource
implements StripeMetadataSource {
    private final StripeMetadataSource delegate;
    private final DwrfStripeCache stripeCache;

    public DwrfAwareStripeMetadataSource(StripeMetadataSource delegate, DwrfStripeCache stripeCache) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.stripeCache = Objects.requireNonNull(stripeCache, "stripeCache is null");
    }

    @Override
    public Slice getStripeFooterSlice(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, long footerOffset, int footerLength, boolean cacheable, long fileModificationTime) throws IOException {
        Optional<Slice> stripeFooterSlice = this.stripeCache.getStripeFooterSlice(stripeId, footerLength);
        if (stripeFooterSlice.isPresent()) {
            return stripeFooterSlice.get();
        }
        return this.delegate.getStripeFooterSlice(orcDataSource, stripeId, footerOffset, footerLength, cacheable, fileModificationTime);
    }

    @Override
    public Map<StreamId, OrcDataSourceInput> getInputs(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, Map<StreamId, DiskRange> diskRanges, boolean cacheable, long fileModificationTime) throws IOException {
        Optional<Slice> stripeCacheIndexStreamsSlice = this.stripeCache.getIndexStreamsSlice(stripeId);
        if (!stripeCacheIndexStreamsSlice.isPresent()) {
            return this.delegate.getInputs(orcDataSource, stripeId, diskRanges, cacheable, fileModificationTime);
        }
        Slice cacheSlice = stripeCacheIndexStreamsSlice.get();
        ImmutableMap.Builder inputsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder dataStreamsBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, DiskRange> entry : diskRanges.entrySet()) {
            StreamId streamId = entry.getKey();
            DiskRange diskRange = entry.getValue();
            if (streamId.getStreamKind().getStreamArea() == Stream.StreamArea.INDEX) {
                Slice slice = cacheSlice.slice(Math.toIntExact(diskRange.getOffset()), diskRange.getLength());
                OrcDataSourceInput orcDataSourceInput = new OrcDataSourceInput((FixedLengthSliceInput)new BasicSliceInput(slice), slice.length());
                inputsBuilder.put((Object)streamId, (Object)orcDataSourceInput);
                continue;
            }
            dataStreamsBuilder.put((Object)streamId, (Object)diskRange);
        }
        ImmutableMap dataStreams = dataStreamsBuilder.build();
        if (!dataStreams.isEmpty()) {
            Map<StreamId, OrcDataSourceInput> dataStreamInputs = this.delegate.getInputs(orcDataSource, stripeId, (Map<StreamId, DiskRange>)dataStreams, cacheable, fileModificationTime);
            inputsBuilder.putAll(dataStreamInputs);
        }
        return inputsBuilder.build();
    }

    @Override
    public List<RowGroupIndex> getRowIndexes(MetadataReader metadataReader, PostScript.HiveWriterVersion hiveWriterVersion, StripeReader.StripeId stripeId, StreamId streamId, OrcInputStream inputStream, List<HiveBloomFilter> bloomFilters, RuntimeStats runtimeStats, long fileModificationTime) throws IOException {
        return this.delegate.getRowIndexes(metadataReader, hiveWriterVersion, stripeId, streamId, inputStream, bloomFilters, runtimeStats, fileModificationTime);
    }
}

