/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CachingStripeMetadataSource
implements StripeMetadataSource {
    private final StripeMetadataSource delegate;
    private final Cache<StripeReader.StripeId, StripeMetadataSource.CacheableSlice> footerSliceCache;
    private final Cache<StripeReader.StripeStreamId, StripeMetadataSource.CacheableSlice> stripeStreamCache;
    private final Optional<Cache<StripeReader.StripeStreamId, StripeMetadataSource.CacheableRowGroupIndices>> rowGroupIndexCache;

    public CachingStripeMetadataSource(StripeMetadataSource delegate, Cache<StripeReader.StripeId, StripeMetadataSource.CacheableSlice> footerSliceCache, Cache<StripeReader.StripeStreamId, StripeMetadataSource.CacheableSlice> stripeStreamCache, Optional<Cache<StripeReader.StripeStreamId, StripeMetadataSource.CacheableRowGroupIndices>> rowGroupIndexCache) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.footerSliceCache = Objects.requireNonNull(footerSliceCache, "footerSliceCache is null");
        this.stripeStreamCache = Objects.requireNonNull(stripeStreamCache, "rowIndexSliceCache is null");
        this.rowGroupIndexCache = Objects.requireNonNull(rowGroupIndexCache, "rowGroupIndexCache is null");
    }

    @Override
    public Slice getStripeFooterSlice(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, long footerOffset, int footerLength, boolean cacheable, long fileModificationTime) throws IOException {
        if (!cacheable) {
            return this.delegate.getStripeFooterSlice(orcDataSource, stripeId, footerOffset, footerLength, cacheable, fileModificationTime);
        }
        try {
            StripeMetadataSource.CacheableSlice cacheableSlice = (StripeMetadataSource.CacheableSlice)this.footerSliceCache.getIfPresent((Object)stripeId);
            if (cacheableSlice != null) {
                if (cacheableSlice.getFileModificationTime() == fileModificationTime) {
                    return cacheableSlice.getSlice();
                }
                this.footerSliceCache.invalidate((Object)stripeId);
                this.footerSliceCache.getIfPresent((Object)stripeId);
            }
            cacheableSlice = new StripeMetadataSource.CacheableSlice(this.delegate.getStripeFooterSlice(orcDataSource, stripeId, footerOffset, footerLength, cacheable, fileModificationTime), fileModificationTime);
            this.footerSliceCache.put((Object)stripeId, (Object)cacheableSlice);
            return cacheableSlice.getSlice();
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IOException("Unexpected error in stripe footer reading after footerSliceCache miss", e.getCause());
        }
    }

    @Override
    public Map<StreamId, OrcDataSourceInput> getInputs(OrcDataSource orcDataSource, StripeReader.StripeId stripeId, Map<StreamId, DiskRange> diskRanges, boolean cacheable, long fileModificationTime) throws IOException {
        StripeMetadataSource.CacheableSlice streamSlice;
        if (!cacheable) {
            return this.delegate.getInputs(orcDataSource, stripeId, diskRanges, cacheable, fileModificationTime);
        }
        ImmutableMap.Builder inputsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder uncachedDiskRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, DiskRange> entry : diskRanges.entrySet()) {
            StripeReader.StripeStreamId stripeStreamId = new StripeReader.StripeStreamId(stripeId, entry.getKey());
            if (CachingStripeMetadataSource.isCachedStream(entry.getKey().getStreamKind())) {
                streamSlice = (StripeMetadataSource.CacheableSlice)this.stripeStreamCache.getIfPresent((Object)stripeStreamId);
                if (streamSlice != null && streamSlice.getFileModificationTime() == fileModificationTime) {
                    inputsBuilder.put((Object)entry.getKey(), (Object)new OrcDataSourceInput((FixedLengthSliceInput)new BasicSliceInput(streamSlice.getSlice()), streamSlice.getSlice().length()));
                    continue;
                }
                if (streamSlice != null) {
                    this.stripeStreamCache.invalidate((Object)stripeStreamId);
                    this.stripeStreamCache.getIfPresent((Object)stripeStreamId);
                }
                uncachedDiskRangesBuilder.put(entry);
                continue;
            }
            uncachedDiskRangesBuilder.put(entry);
        }
        Map<StreamId, OrcDataSourceInput> uncachedInputs = this.delegate.getInputs(orcDataSource, stripeId, (Map<StreamId, DiskRange>)uncachedDiskRangesBuilder.build(), cacheable, fileModificationTime);
        for (Map.Entry<StreamId, OrcDataSourceInput> entry : uncachedInputs.entrySet()) {
            if (CachingStripeMetadataSource.isCachedStream(entry.getKey().getStreamKind())) {
                streamSlice = Slices.wrappedBuffer((byte[])entry.getValue().getInput().readSlice(Math.toIntExact(entry.getValue().getInput().length())).getBytes());
                this.stripeStreamCache.put((Object)new StripeReader.StripeStreamId(stripeId, entry.getKey()), (Object)new StripeMetadataSource.CacheableSlice((Slice)streamSlice, fileModificationTime));
                inputsBuilder.put((Object)entry.getKey(), (Object)new OrcDataSourceInput((FixedLengthSliceInput)new BasicSliceInput((Slice)streamSlice), Math.toIntExact(streamSlice.getRetainedSize())));
                continue;
            }
            inputsBuilder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return inputsBuilder.build();
    }

    @Override
    public List<RowGroupIndex> getRowIndexes(MetadataReader metadataReader, PostScript.HiveWriterVersion hiveWriterVersion, StripeReader.StripeId stripId, StreamId streamId, OrcInputStream inputStream, List<HiveBloomFilter> bloomFilters, RuntimeStats runtimeStats, long fileModificationTime) throws IOException {
        StripeReader.StripeStreamId stripeStreamId = new StripeReader.StripeStreamId(stripId, streamId);
        if (this.rowGroupIndexCache.isPresent()) {
            StripeMetadataSource.CacheableRowGroupIndices cacheableRowGroupIndices = (StripeMetadataSource.CacheableRowGroupIndices)this.rowGroupIndexCache.get().getIfPresent((Object)stripeStreamId);
            if (cacheableRowGroupIndices != null && cacheableRowGroupIndices.getFileModificationTime() == fileModificationTime) {
                runtimeStats.addMetricValue("OrcRowGroupIndexCacheHit", RuntimeUnit.NONE, 1L);
                runtimeStats.addMetricValue("OrcRowGroupIndexInMemoryBytesRead", RuntimeUnit.BYTE, cacheableRowGroupIndices.getRowGroupIndices().stream().mapToLong(RowGroupIndex::getRetainedSizeInBytes).sum());
                return cacheableRowGroupIndices.getRowGroupIndices();
            }
            if (cacheableRowGroupIndices != null) {
                this.rowGroupIndexCache.get().invalidate((Object)stripeStreamId);
                this.rowGroupIndexCache.get().getIfPresent((Object)stripeStreamId);
            }
            runtimeStats.addMetricValue("OrcRowGroupIndexCacheHit", RuntimeUnit.NONE, 0L);
            runtimeStats.addMetricValue("OrcRowGroupIndexStorageBytesRead", RuntimeUnit.BYTE, inputStream.getRetainedSizeInBytes());
        }
        List<RowGroupIndex> rowGroupIndices = this.delegate.getRowIndexes(metadataReader, hiveWriterVersion, stripId, streamId, inputStream, bloomFilters, runtimeStats, fileModificationTime);
        if (this.rowGroupIndexCache.isPresent()) {
            this.rowGroupIndexCache.get().put((Object)stripeStreamId, (Object)new StripeMetadataSource.CacheableRowGroupIndices(rowGroupIndices, fileModificationTime));
        }
        return rowGroupIndices;
    }

    private static boolean isCachedStream(Stream.StreamKind streamKind) {
        return streamKind == Stream.StreamKind.BLOOM_FILTER || streamKind == Stream.StreamKind.ROW_INDEX;
    }
}

