/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.MapStatisticsEntry;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class MapStatistics
implements StatisticsHasher.Hashable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapStatistics.class).instanceSize();
    private final List<MapStatisticsEntry> entries;

    public MapStatistics(List<MapStatisticsEntry> entries) {
        this.entries = Objects.requireNonNull(entries, "entries is null");
    }

    public List<MapStatisticsEntry> getEntries() {
        return this.entries;
    }

    public long getRetainedSizeInBytes() {
        long entriesSize = 0L;
        for (MapStatisticsEntry entry : this.entries) {
            entriesSize += entry.getRetainedSizeInBytes();
        }
        return (long)INSTANCE_SIZE + entriesSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapStatistics that = (MapStatistics)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entries", this.entries).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        this.entries.forEach(hasher::putOptionalHashable);
    }
}

