/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class RowGroupIndex {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowGroupIndex.class).instanceSize();
    private final int[] positions;
    private final ColumnStatistics statistics;

    public RowGroupIndex(int[] positions, ColumnStatistics statistics) {
        this.positions = Objects.requireNonNull(positions, "positions is null");
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public int[] getPositions() {
        return this.positions;
    }

    public ColumnStatistics getColumnStatistics() {
        return this.statistics;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.positions) + this.statistics.getRetainedSizeInBytes();
    }
}

