/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.NoopOrcLocalMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcFileIntrospector;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.checkpoint.Checkpoints;
import com.facebook.presto.orc.checkpoint.InvalidCheckpointException;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.DwrfMetadataReader;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeEncryptionGroup;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.stream.CheckpointInputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.facebook.presto.orc.stream.ValueInputStreamSource;
import com.facebook.presto.orc.stream.ValueStreams;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;

public class StripeReader {
    private final OrcDataSource orcDataSource;
    private final Optional<OrcDecompressor> decompressor;
    private final List<OrcType> types;
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final Set<Integer> includedOrcColumns;
    private final int rowsInRowGroup;
    private final OrcPredicate predicate;
    private final MetadataReader metadataReader;
    private final Optional<OrcWriteValidation> writeValidation;
    private final StripeMetadataSource stripeMetadataSource;
    private final boolean cacheable;
    private final Multimap<Integer, Integer> dwrfEncryptionGroupColumns;
    private final RuntimeStats runtimeStats;
    private final Optional<OrcFileIntrospector> fileIntrospector;

    public StripeReader(OrcDataSource orcDataSource, Optional<OrcDecompressor> decompressor, List<OrcType> types, Set<Integer> includedOrcColumns, int rowsInRowGroup, OrcPredicate predicate, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, Optional<OrcWriteValidation> writeValidation, StripeMetadataSource stripeMetadataSource, boolean cacheable, Map<Integer, Integer> dwrfEncryptionGroupMap, RuntimeStats runtimeStats, Optional<OrcFileIntrospector> fileIntrospector) {
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.includedOrcColumns = Objects.requireNonNull(includedOrcColumns, "includedColumns is null");
        this.rowsInRowGroup = rowsInRowGroup;
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.hiveWriterVersion = Objects.requireNonNull(hiveWriterVersion, "hiveWriterVersion is null");
        this.metadataReader = Objects.requireNonNull(metadataReader, "metadataReader is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.stripeMetadataSource = Objects.requireNonNull(stripeMetadataSource, "stripeMetadataSource is null");
        this.cacheable = cacheable;
        this.dwrfEncryptionGroupColumns = this.invertEncryptionGroupMap(Objects.requireNonNull(dwrfEncryptionGroupMap, "dwrfEncryptionGroupMap is null"));
        this.runtimeStats = Objects.requireNonNull(runtimeStats, "runtimeStats is null");
        this.fileIntrospector = Objects.requireNonNull(fileIntrospector, "fileIntrospector is null");
    }

    private Multimap<Integer, Integer> invertEncryptionGroupMap(Map<Integer, Integer> dwrfEncryptionGroupMap) {
        ImmutableMultimap.Builder invertedMapBuilder = ImmutableMultimap.builder();
        for (Map.Entry<Integer, Integer> entry : dwrfEncryptionGroupMap.entrySet()) {
            invertedMapBuilder.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (int i = 0; i < this.types.size(); ++i) {
            if (dwrfEncryptionGroupMap.containsKey(i)) continue;
            invertedMapBuilder.put((Object)-1, (Object)i);
        }
        return invertedMapBuilder.build();
    }

    public Stripe readStripe(StripeInformation stripe, OrcAggregatedMemoryContext systemMemoryUsage, Optional<DwrfEncryptionInfo> decryptors, SharedBuffer sharedDecompressionBuffer) throws IOException {
        StripeId stripeId = new StripeId(this.orcDataSource.getId(), stripe.getOffset());
        StripeFooter stripeFooter = this.readStripeFooter(stripeId, stripe, systemMemoryUsage);
        this.fileIntrospector.ifPresent(introspector -> introspector.onStripeFooter(stripe, stripeFooter));
        ArrayList<List<Stream>> allStreams = new ArrayList<List<Stream>>();
        allStreams.add(stripeFooter.getStreams());
        HashMap<StreamId, Stream> includedStreams = new HashMap<StreamId, Stream>();
        boolean hasRowGroupDictionary = this.addIncludedStreams(stripeFooter.getColumnEncodings(), stripeFooter.getStreams(), includedStreams);
        HashMap<Integer, ColumnEncoding> columnEncodings = new HashMap<Integer, ColumnEncoding>();
        Map<Integer, ColumnEncoding> stripeFooterEncodings = stripeFooter.getColumnEncodings();
        columnEncodings.putAll(stripeFooterEncodings);
        if (decryptors.isPresent()) {
            List<Slice> encryptedEncryptionGroups = stripeFooter.getStripeEncryptionGroups();
            for (Integer groupId : decryptors.get().getEncryptorGroupIds()) {
                StripeEncryptionGroup stripeEncryptionGroup = this.getStripeEncryptionGroup(decryptors.get().getEncryptorByGroupId(groupId), encryptedEncryptionGroups.get(groupId), this.dwrfEncryptionGroupColumns.get((Object)groupId), systemMemoryUsage);
                allStreams.add(stripeEncryptionGroup.getStreams());
                columnEncodings.putAll(stripeEncryptionGroup.getColumnEncodings());
                boolean encryptedHasRowGroupDictionary = this.addIncludedStreams(stripeEncryptionGroup.getColumnEncodings(), stripeEncryptionGroup.getStreams(), includedStreams);
                hasRowGroupDictionary = encryptedHasRowGroupDictionary || hasRowGroupDictionary;
            }
        }
        boolean invalidCheckPoint = false;
        if (stripe.getNumberOfRows() > (long)this.rowsInRowGroup || hasRowGroupDictionary) {
            Set<Integer> selectedRowGroups;
            Map diskRanges = StripeReader.getDiskRanges(allStreams);
            diskRanges = Maps.filterKeys(diskRanges, (Predicate)Predicates.in(includedStreams.keySet()));
            Map<StreamId, OrcInputStream> streamsData = this.readDiskRanges(stripeId, diskRanges, systemMemoryUsage, decryptors, sharedDecompressionBuffer);
            Map<StreamId, List<RowGroupIndex>> columnIndexes = this.readColumnIndexes(includedStreams, streamsData, stripeId);
            this.fileIntrospector.ifPresent(introspector -> introspector.onRowGroupIndexes(stripe, columnIndexes));
            if (this.writeValidation.isPresent()) {
                this.writeValidation.get().validateRowGroupStatistics(this.orcDataSource.getId(), stripe.getOffset(), columnIndexes);
            }
            if ((selectedRowGroups = this.selectRowGroups(stripe, columnIndexes)).isEmpty()) {
                systemMemoryUsage.close();
                return null;
            }
            Map<StreamId, ValueInputStream<?>> valueStreams = this.createValueStreams(includedStreams, streamsData, columnEncodings);
            InputStreamSources dictionaryStreamSources = this.createDictionaryStreamSources(includedStreams, valueStreams, columnEncodings);
            try {
                List<RowGroup> rowGroups = this.createRowGroups(stripe.getNumberOfRows(), includedStreams, valueStreams, columnIndexes, selectedRowGroups, columnEncodings);
                return new Stripe(stripe.getNumberOfRows(), columnEncodings, rowGroups, dictionaryStreamSources);
            }
            catch (InvalidCheckpointException e) {
                if (hasRowGroupDictionary) {
                    throw new OrcCorruptionException(e, this.orcDataSource.getId(), "Checkpoints are corrupt", new Object[0]);
                }
                invalidCheckPoint = true;
            }
        }
        ImmutableMap.Builder diskRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, DiskRange> entry : StripeReader.getDiskRanges(allStreams).entrySet()) {
            StreamId streamId = entry.getKey();
            if (!includedStreams.containsKey(streamId)) continue;
            diskRangesBuilder.put(entry);
        }
        ImmutableMap diskRanges = diskRangesBuilder.build();
        Map<StreamId, OrcInputStream> streamsData = this.readDiskRanges(stripeId, (Map<StreamId, DiskRange>)diskRanges, systemMemoryUsage, decryptors, sharedDecompressionBuffer);
        long totalBytes = 0L;
        ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
        for (Map.Entry entry : includedStreams.entrySet()) {
            if (((StreamId)entry.getKey()).getStreamKind() != Stream.StreamKind.ROW_INDEX) continue;
            List<RowGroupIndex> rowGroupIndexes = this.metadataReader.readRowIndexes(this.hiveWriterVersion, streamsData.get(entry.getKey()), null);
            Preconditions.checkState((rowGroupIndexes.size() == 1 || invalidCheckPoint ? 1 : 0) != 0, (Object)"expect a single row group or an invalid check point");
            for (RowGroupIndex rowGroupIndex : rowGroupIndexes) {
                ColumnStatistics columnStatistics = rowGroupIndex.getColumnStatistics();
                if (!columnStatistics.hasMinAverageValueSizeInBytes()) continue;
                totalBytes += columnStatistics.getTotalValueSizeInBytes();
            }
            if (!this.fileIntrospector.isPresent()) continue;
            columnIndexes.put(entry.getKey(), rowGroupIndexes);
        }
        this.fileIntrospector.ifPresent(introspector -> introspector.onRowGroupIndexes(stripe, (Map<StreamId, List<RowGroupIndex>>)columnIndexes.build()));
        Map<StreamId, ValueInputStream<?>> valueStreams = this.createValueStreams(includedStreams, streamsData, columnEncodings);
        InputStreamSources dictionaryStreamSources = this.createDictionaryStreamSources(includedStreams, valueStreams, columnEncodings);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<StreamId, ValueInputStream<?>> entry : valueStreams.entrySet()) {
            builder.put((Object)entry.getKey(), new ValueInputStreamSource(entry.getValue()));
        }
        RowGroup rowGroup = new RowGroup(0, 0L, stripe.getNumberOfRows(), totalBytes, new InputStreamSources((Map<StreamId, InputStreamSource<?>>)builder.build()));
        return new Stripe(stripe.getNumberOfRows(), columnEncodings, (List<RowGroup>)ImmutableList.of((Object)rowGroup), dictionaryStreamSources);
    }

    private StripeEncryptionGroup getStripeEncryptionGroup(DwrfDataEncryptor decryptor, Slice encryptedGroup, Collection<Integer> columns, OrcAggregatedMemoryContext systemMemoryUsage) throws IOException {
        OrcInputStream orcInputStream = new OrcInputStream(this.orcDataSource.getId(), new SharedBuffer(NoopOrcLocalMemoryContext.NOOP_ORC_LOCAL_MEMORY_CONTEXT), (FixedLengthSliceInput)encryptedGroup.getInput(), this.decompressor, Optional.of(decryptor), systemMemoryUsage, encryptedGroup.length());
        return DwrfMetadataReader.toStripeEncryptionGroup(this.orcDataSource.getId(), orcInputStream, this.types);
    }

    private boolean addIncludedStreams(Map<Integer, ColumnEncoding> columnEncodings, List<Stream> streams, Map<StreamId, Stream> includedStreams) {
        boolean hasRowGroupDictionary = false;
        for (Stream stream : streams) {
            Optional<SortedMap<Integer, DwrfSequenceEncoding>> additionalSequenceEncodings;
            if (!this.includedOrcColumns.contains(stream.getColumn())) continue;
            includedStreams.put(new StreamId(stream), stream);
            if (stream.getStreamKind() != Stream.StreamKind.IN_DICTIONARY) continue;
            ColumnEncoding columnEncoding = columnEncodings.get(stream.getColumn());
            if (columnEncoding.getColumnEncodingKind() == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
                hasRowGroupDictionary = true;
            }
            if (!(additionalSequenceEncodings = columnEncoding.getAdditionalSequenceEncodings()).isPresent() || !additionalSequenceEncodings.get().values().stream().map(DwrfSequenceEncoding::getValueEncoding).anyMatch(encoding -> encoding.getColumnEncodingKind() == ColumnEncoding.ColumnEncodingKind.DICTIONARY)) continue;
            hasRowGroupDictionary = true;
        }
        return hasRowGroupDictionary;
    }

    private Map<StreamId, OrcInputStream> readDiskRanges(StripeId stripeId, Map<StreamId, DiskRange> diskRanges, OrcAggregatedMemoryContext systemMemoryUsage, Optional<DwrfEncryptionInfo> decryptors, SharedBuffer sharedDecompressionBuffer) throws IOException {
        Map<StreamId, OrcDataSourceInput> streamsData = this.stripeMetadataSource.getInputs(this.orcDataSource, stripeId, diskRanges, this.cacheable);
        ImmutableMap.Builder streamsBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, OrcDataSourceInput> entry : streamsData.entrySet()) {
            OrcDataSourceInput sourceInput = entry.getValue();
            Optional<DwrfDataEncryptor> dwrfDecryptor = this.createDwrfDecryptor(entry.getKey(), decryptors);
            streamsBuilder.put((Object)entry.getKey(), (Object)new OrcInputStream(this.orcDataSource.getId(), sharedDecompressionBuffer, sourceInput.getInput(), this.decompressor, dwrfDecryptor, systemMemoryUsage, sourceInput.getRetainedSizeInBytes()));
        }
        return streamsBuilder.build();
    }

    private Optional<DwrfDataEncryptor> createDwrfDecryptor(StreamId id, Optional<DwrfEncryptionInfo> decryptors) {
        if (!decryptors.isPresent()) {
            return Optional.empty();
        }
        return decryptors.get().getEncryptorByNodeId(id.getColumn());
    }

    private Map<StreamId, ValueInputStream<?>> createValueStreams(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData, Map<Integer, ColumnEncoding> columnEncodings) {
        ImmutableMap.Builder valueStreams = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            StreamId streamId = entry.getKey();
            Stream stream = entry.getValue();
            ColumnEncoding.ColumnEncodingKind columnEncoding = columnEncodings.get(stream.getColumn()).getColumnEncoding(stream.getSequence()).getColumnEncodingKind();
            if (StripeReader.isIndexStream(stream) || stream.getLength() == 0) continue;
            OrcInputStream inputStream = streamsData.get(streamId);
            OrcType.OrcTypeKind columnType = this.types.get(stream.getColumn()).getOrcTypeKind();
            valueStreams.put((Object)streamId, ValueStreams.createValueStreams(streamId, inputStream, columnType, columnEncoding, stream.isUseVInts()));
        }
        return valueStreams.build();
    }

    public InputStreamSources createDictionaryStreamSources(Map<StreamId, Stream> streams, Map<StreamId, ValueInputStream<?>> valueStreams, Map<Integer, ColumnEncoding> columnEncodings) {
        ImmutableMap.Builder dictionaryStreamBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            ValueInputStream<?> valueStream;
            int column;
            ColumnEncoding.ColumnEncodingKind columnEncoding;
            StreamId streamId = entry.getKey();
            Stream stream = entry.getValue();
            if (!StripeReader.isDictionary(stream, columnEncoding = columnEncodings.get(column = stream.getColumn()).getColumnEncoding(stream.getSequence()).getColumnEncodingKind()) || (valueStream = valueStreams.get(streamId)) == null) continue;
            OrcType.OrcTypeKind columnType = this.types.get(stream.getColumn()).getOrcTypeKind();
            StreamCheckpoint streamCheckpoint = Checkpoints.getDictionaryStreamCheckpoint(streamId, columnType, columnEncoding);
            CheckpointInputStreamSource streamSource = CheckpointInputStreamSource.createCheckpointStreamSource(valueStream, streamCheckpoint);
            dictionaryStreamBuilder.put((Object)streamId, streamSource);
        }
        return new InputStreamSources((Map<StreamId, InputStreamSource<?>>)dictionaryStreamBuilder.build());
    }

    private List<RowGroup> createRowGroups(long rowsInStripe, Map<StreamId, Stream> streams, Map<StreamId, ValueInputStream<?>> valueStreams, Map<StreamId, List<RowGroupIndex>> columnIndexes, Set<Integer> selectedRowGroups, Map<Integer, ColumnEncoding> encodings) throws InvalidCheckpointException {
        ImmutableList.Builder rowGroupBuilder = ImmutableList.builder();
        for (int rowGroupId : selectedRowGroups) {
            Map<StreamId, StreamCheckpoint> checkpoints = Checkpoints.getStreamCheckpoints(this.includedOrcColumns, this.types, this.decompressor.isPresent(), rowGroupId, encodings, streams, columnIndexes);
            rowGroupBuilder.add((Object)StripeReader.createRowGroup(rowGroupId, rowsInStripe, this.rowsInRowGroup, columnIndexes, valueStreams, checkpoints));
        }
        return rowGroupBuilder.build();
    }

    @VisibleForTesting
    static RowGroup createRowGroup(int groupId, long rowsInStripe, long rowsInRowGroup, Map<StreamId, List<RowGroupIndex>> columnIndexes, Map<StreamId, ValueInputStream<?>> valueStreams, Map<StreamId, StreamCheckpoint> checkpoints) {
        long totalRowGroupBytes = columnIndexes.values().stream().mapToLong(e -> ((RowGroupIndex)e.get(groupId)).getColumnStatistics().getTotalValueSizeInBytes()).sum();
        long rowOffset = Math.multiplyExact((long)groupId, rowsInRowGroup);
        int rowCount = Math.toIntExact(Math.min(rowsInStripe - rowOffset, rowsInRowGroup));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<StreamId, StreamCheckpoint> entry : checkpoints.entrySet()) {
            StreamId streamId = entry.getKey();
            StreamCheckpoint checkpoint = entry.getValue();
            ValueInputStream<?> valueStream = valueStreams.get(streamId);
            if (valueStream == null) continue;
            builder.put((Object)streamId, CheckpointInputStreamSource.createCheckpointStreamSource(valueStream, checkpoint));
        }
        InputStreamSources rowGroupStreams = new InputStreamSources((Map<StreamId, InputStreamSource<?>>)builder.build());
        return new RowGroup(groupId, rowOffset, rowCount, totalRowGroupBytes, rowGroupStreams);
    }

    public StripeFooter readStripeFooter(StripeId stripeId, StripeInformation stripe, OrcAggregatedMemoryContext systemMemoryUsage) throws IOException {
        long footerOffset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int footerLength = Math.toIntExact(stripe.getFooterLength());
        Slice footerSlice = this.stripeMetadataSource.getStripeFooterSlice(this.orcDataSource, stripeId, footerOffset, footerLength, this.cacheable);
        try (OrcInputStream inputStream = new OrcInputStream(this.orcDataSource.getId(), new SharedBuffer(NoopOrcLocalMemoryContext.NOOP_ORC_LOCAL_MEMORY_CONTEXT), (FixedLengthSliceInput)footerSlice.getInput(), this.decompressor, Optional.empty(), systemMemoryUsage, footerLength);){
            StripeFooter stripeFooter = this.metadataReader.readStripeFooter(this.orcDataSource.getId(), this.types, inputStream);
            return stripeFooter;
        }
    }

    static boolean isIndexStream(Stream stream) {
        return stream.getStreamKind().getStreamArea() == Stream.StreamArea.INDEX;
    }

    private Map<Integer, List<HiveBloomFilter>> readBloomFilterIndexes(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData) throws IOException {
        ImmutableMap.Builder bloomFilters = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            Stream stream = entry.getValue();
            if (stream.getStreamKind() != Stream.StreamKind.BLOOM_FILTER) continue;
            OrcInputStream inputStream = streamsData.get(entry.getKey());
            bloomFilters.put((Object)entry.getKey().getColumn(), this.metadataReader.readBloomFilterIndexes(inputStream));
        }
        return bloomFilters.build();
    }

    private Map<StreamId, List<RowGroupIndex>> readColumnIndexes(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData, StripeId stripeId) throws IOException {
        Map<Integer, List<HiveBloomFilter>> bloomFilterIndexes = this.readBloomFilterIndexes(streams, streamsData);
        ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            StreamId streamId = entry.getKey();
            Stream stream = entry.getValue();
            if (stream.getStreamKind() != Stream.StreamKind.ROW_INDEX) continue;
            OrcInputStream inputStream = streamsData.get(streamId);
            List<HiveBloomFilter> bloomFilters = bloomFilterIndexes.get(streamId.getColumn());
            List<RowGroupIndex> rowGroupIndexes = this.stripeMetadataSource.getRowIndexes(this.metadataReader, this.hiveWriterVersion, stripeId, streamId, inputStream, bloomFilters, this.runtimeStats);
            columnIndexes.put((Object)entry.getKey(), rowGroupIndexes);
        }
        return columnIndexes.build();
    }

    private Set<Integer> selectRowGroups(StripeInformation stripe, Map<StreamId, List<RowGroupIndex>> columnIndexes) {
        long rowsInStripe = stripe.getNumberOfRows();
        int groupsInStripe = StripeReader.ceil(rowsInStripe, this.rowsInRowGroup);
        ImmutableSet.Builder selectedRowGroups = ImmutableSet.builder();
        long remainingRows = rowsInStripe;
        for (int rowGroup = 0; rowGroup < groupsInStripe; ++rowGroup) {
            Map<Integer, ColumnStatistics> statistics;
            int rows = Math.toIntExact(Math.min(remainingRows, (long)this.rowsInRowGroup));
            if (this.predicate.matches(rows, statistics = StripeReader.getRowGroupStatistics(this.types.get(0), columnIndexes, rowGroup))) {
                selectedRowGroups.add((Object)rowGroup);
            }
            remainingRows -= (long)rows;
        }
        return selectedRowGroups.build();
    }

    private static Map<Integer, ColumnStatistics> getRowGroupStatistics(OrcType rootStructType, Map<StreamId, List<RowGroupIndex>> columnIndexes, int rowGroup) {
        Objects.requireNonNull(rootStructType, "rootStructType is null");
        Preconditions.checkArgument((rootStructType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT ? 1 : 0) != 0);
        Objects.requireNonNull(columnIndexes, "columnIndexes is null");
        Preconditions.checkArgument((rowGroup >= 0 ? 1 : 0) != 0, (Object)"rowGroup is negative");
        HashMap<Integer, List> groupedColumnStatistics = new HashMap<Integer, List>();
        for (Map.Entry<StreamId, List<RowGroupIndex>> entry : columnIndexes.entrySet()) {
            if (entry.getValue().isEmpty() || entry.getValue().get(rowGroup) == null) continue;
            groupedColumnStatistics.computeIfAbsent(entry.getKey().getColumn(), key -> new ArrayList()).add(entry.getValue().get(rowGroup).getColumnStatistics());
        }
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < rootStructType.getFieldCount(); ++ordinal) {
            List columnStatistics = (List)groupedColumnStatistics.get(rootStructType.getFieldTypeIndex(ordinal));
            if (columnStatistics == null) continue;
            if (columnStatistics.size() == 1) {
                statistics.put((Object)ordinal, Iterables.getOnlyElement((Iterable)columnStatistics));
                continue;
            }
            statistics.put((Object)ordinal, (Object)ColumnStatistics.mergeColumnStatistics(columnStatistics));
        }
        return statistics.build();
    }

    private static boolean isDictionary(Stream stream, ColumnEncoding.ColumnEncodingKind columnEncoding) {
        return stream.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA || stream.getStreamKind() == Stream.StreamKind.LENGTH && (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY || columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2);
    }

    @VisibleForTesting
    public static Map<StreamId, DiskRange> getDiskRanges(List<List<Stream>> streams) {
        ImmutableMap.Builder streamDiskRanges = ImmutableMap.builder();
        for (List<Stream> groupStreams : streams) {
            long stripeOffset = 0L;
            for (Stream stream : groupStreams) {
                int streamLength = Math.toIntExact(stream.getLength());
                if (stream.getOffset().isPresent()) {
                    stripeOffset = stream.getOffset().get();
                }
                if (streamLength > 0) {
                    streamDiskRanges.put((Object)new StreamId(stream), (Object)new DiskRange(stripeOffset, streamLength));
                }
                stripeOffset += (long)streamLength;
            }
        }
        return streamDiskRanges.build();
    }

    private static int ceil(long dividend, int divisor) {
        long ceil = (dividend + (long)divisor - 1L) / (long)divisor;
        return Math.toIntExact(ceil);
    }

    public static class StripeStreamId {
        private final StripeId stripeId;
        private final int column;
        private final int sequence;
        private final Stream.StreamKind streamKind;

        public StripeStreamId(StripeId stripeId, StreamId streamId) {
            this.stripeId = Objects.requireNonNull(stripeId, "stripeId is null");
            Objects.requireNonNull(streamId, "streamId is null");
            this.column = streamId.getColumn();
            this.sequence = streamId.getSequence();
            this.streamKind = streamId.getStreamKind();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StripeStreamId other = (StripeStreamId)o;
            return Objects.equals(this.stripeId, other.stripeId) && this.column == other.column && this.sequence == other.sequence && this.streamKind == other.streamKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.stripeId, this.column, this.sequence, this.streamKind});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("stripeId", (Object)this.stripeId).add("column", this.column).add("sequence", this.sequence).add("streamKind", (Object)this.streamKind).toString();
        }
    }

    public static class StripeId {
        private final OrcDataSourceId sourceId;
        private final long offset;

        public StripeId(OrcDataSourceId sourceId, long offset) {
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.offset = offset;
        }

        public OrcDataSourceId getSourceId() {
            return this.sourceId;
        }

        public long getOffset() {
            return this.offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StripeId stripeId = (StripeId)o;
            return this.offset == stripeId.offset && Objects.equals(this.sourceId, stripeId.sourceId);
        }

        public int hashCode() {
            return Objects.hash(this.sourceId, this.offset);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sourceId", (Object)this.sourceId).add("offset", this.offset).toString();
        }
    }
}

