/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class StreamDescriptorFactory {
    private static final int ROOT_ID = 0;

    private StreamDescriptorFactory() {
    }

    public static StreamDescriptor createStreamDescriptor(List<OrcType> types, OrcDataSource dataSource) {
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builderWithExpectedSize((int)types.size());
        StreamDescriptorFactory.addOrcType("", "", 0, types, (ImmutableMap.Builder<Integer, StreamProperty>)propertiesBuilder);
        AllStreams allStreams = new AllStreams(dataSource, (Map<Integer, StreamProperty>)propertiesBuilder.build());
        return new StreamDescriptor(0, 0, allStreams);
    }

    private static void addOrcType(String parentStreamName, String fieldName, int typeId, List<OrcType> types, ImmutableMap.Builder<Integer, StreamProperty> propertiesBuilder) {
        OrcType type = types.get(typeId);
        if (!fieldName.isEmpty()) {
            parentStreamName = parentStreamName + "." + fieldName;
        }
        ImmutableList.Builder nestedStreamIdsBuilder = ImmutableList.builderWithExpectedSize((int)type.getFieldCount());
        if (type.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            for (int i = 0; i < type.getFieldCount(); ++i) {
                nestedStreamIdsBuilder.add((Object)type.getFieldTypeIndex(i));
                StreamDescriptorFactory.addOrcType(parentStreamName, type.getFieldName(i), type.getFieldTypeIndex(i), types, propertiesBuilder);
            }
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.LIST) {
            nestedStreamIdsBuilder.add((Object)type.getFieldTypeIndex(0));
            StreamDescriptorFactory.addOrcType(parentStreamName, "item", type.getFieldTypeIndex(0), types, propertiesBuilder);
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.MAP) {
            nestedStreamIdsBuilder.add((Object)type.getFieldTypeIndex(0));
            nestedStreamIdsBuilder.add((Object)type.getFieldTypeIndex(1));
            StreamDescriptorFactory.addOrcType(parentStreamName, "key", type.getFieldTypeIndex(0), types, propertiesBuilder);
            StreamDescriptorFactory.addOrcType(parentStreamName, "value", type.getFieldTypeIndex(1), types, propertiesBuilder);
        }
        StreamProperty streamProperty = new StreamProperty(parentStreamName, type, fieldName, (List<Integer>)nestedStreamIdsBuilder.build());
        propertiesBuilder.put((Object)typeId, (Object)streamProperty);
    }

    public static class AllStreams {
        private final OrcDataSource orcDataSource;
        private final Map<Integer, StreamProperty> streamIdToProperties;

        public AllStreams(OrcDataSource orcDataSource, Map<Integer, StreamProperty> streamIdToProperties) {
            this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
            this.streamIdToProperties = ImmutableMap.copyOf(Objects.requireNonNull(streamIdToProperties, "streamProperties is null"));
        }

        public OrcDataSource getOrcDataSource() {
            return this.orcDataSource;
        }

        public StreamProperty getStreamProperty(int streamId) {
            StreamProperty streamProperty = this.streamIdToProperties.get(streamId);
            Preconditions.checkState((streamProperty != null ? 1 : 0) != 0, (String)"StreamId %s is missing", (int)streamId);
            return streamProperty;
        }
    }

    public static class StreamProperty {
        private final String streamName;
        private final OrcType orcType;
        private final String fieldName;
        private final List<Integer> nestedStreamIds;

        public StreamProperty(String streamName, OrcType orcType, String fieldName, List<Integer> nestedStreamIds) {
            this.streamName = Objects.requireNonNull(streamName, "streamName is null");
            this.orcType = Objects.requireNonNull(orcType, "orcType is null");
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName is null");
            this.nestedStreamIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(nestedStreamIds, "nestedStreamIds is null"));
        }

        public String getStreamName() {
            return this.streamName;
        }

        public OrcType getOrcType() {
            return this.orcType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public List<Integer> getNestedStreamIds() {
            return this.nestedStreamIds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreamProperty that = (StreamProperty)o;
            return Objects.equals(this.streamName, that.streamName) && Objects.equals(this.orcType, that.orcType) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.nestedStreamIds, that.nestedStreamIds);
        }

        public int hashCode() {
            return Objects.hash(this.streamName, this.orcType, this.fieldName, this.nestedStreamIds);
        }
    }
}

