/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface StreamLayout {
    public void reorder(List<StreamDataOutput> var1, Map<Integer, Integer> var2, Map<Integer, ColumnEncoding> var3);

    public static class ByColumnSize
    implements StreamLayout {
        public void reorder(List<StreamDataOutput> dataStreams) {
            Objects.requireNonNull(dataStreams, "dataStreams is null");
            if (dataStreams.isEmpty()) {
                return;
            }
            Map columnSizes = (Map)dataStreams.stream().collect(ImmutableMap.toImmutableMap(s -> s.getStream().getColumn(), s -> s.getStream().getLength(), Long::sum));
            dataStreams.sort((left, right) -> {
                Stream leftStream = left.getStream();
                Stream rightStream = right.getStream();
                long sizeDelta = (Long)columnSizes.get(leftStream.getColumn()) - (Long)columnSizes.get(rightStream.getColumn());
                if (sizeDelta != 0L) {
                    return sizeDelta < 0L ? -1 : 1;
                }
                int columnDelta = leftStream.getColumn() - rightStream.getColumn();
                if (columnDelta != 0) {
                    return columnDelta;
                }
                sizeDelta = leftStream.getLength() - rightStream.getLength();
                if (sizeDelta != 0L) {
                    return sizeDelta < 0L ? -1 : 1;
                }
                return leftStream.getStreamKind().compareTo(rightStream.getStreamKind());
            });
        }

        @Override
        public void reorder(List<StreamDataOutput> dataStreams, Map<Integer, Integer> nodeIdToColumn, Map<Integer, ColumnEncoding> nodeIdToColumnEncodings) {
            this.reorder(dataStreams);
        }

        public String toString() {
            return "ByColumnSize{}";
        }
    }

    public static class ByStreamSize
    implements StreamLayout {
        public void reorder(List<StreamDataOutput> dataStreams) {
            Collections.sort(Objects.requireNonNull(dataStreams, "dataStreams is null"));
        }

        @Override
        public void reorder(List<StreamDataOutput> dataStreams, Map<Integer, Integer> nodeIdToColumn, Map<Integer, ColumnEncoding> nodeIdToColumnEncodings) {
            this.reorder(dataStreams);
        }

        public String toString() {
            return "ByStreamSize{}";
        }
    }
}

