/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

public enum DwrfStripeCacheMode {
    NONE(false, false),
    INDEX(true, false),
    FOOTER(false, true),
    INDEX_AND_FOOTER(true, true);

    private final boolean hasIndex;
    private final boolean hasFooter;

    private DwrfStripeCacheMode(boolean hasIndex, boolean hasFooter) {
        this.hasIndex = hasIndex;
        this.hasFooter = hasFooter;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public int getIndexOffsetPosition(int stripeOrdinal) {
        switch (this) {
            case INDEX: {
                return stripeOrdinal;
            }
            case INDEX_AND_FOOTER: {
                return stripeOrdinal * 2;
            }
        }
        throw new IllegalStateException("This mode doesn't support index cache: " + (Object)((Object)this));
    }

    public int getFooterOffsetPosition(int stripeOrdinal) {
        switch (this) {
            case FOOTER: {
                return stripeOrdinal;
            }
            case INDEX_AND_FOOTER: {
                return stripeOrdinal * 2 + 1;
            }
        }
        throw new IllegalStateException("This mode doesn't support footer cache: " + (Object)((Object)this));
    }
}

