/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.checkpoint;

import com.facebook.presto.orc.checkpoint.Checkpoints;
import com.facebook.presto.orc.checkpoint.InputStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class LongStreamV1Checkpoint
implements LongStreamCheckpoint {
    private final int offset;
    private final long inputStreamCheckpoint;

    public LongStreamV1Checkpoint(int offset, long inputStreamCheckpoint) {
        this.offset = offset;
        this.inputStreamCheckpoint = inputStreamCheckpoint;
    }

    public LongStreamV1Checkpoint(boolean compressed, Checkpoints.ColumnPositionsList positionsList) {
        this.inputStreamCheckpoint = InputStreamCheckpoint.createInputStreamCheckpoint(compressed, positionsList);
        this.offset = positionsList.nextPosition();
    }

    public int getOffset() {
        return this.offset;
    }

    public long getInputStreamCheckpoint() {
        return this.inputStreamCheckpoint;
    }

    @Override
    public List<Integer> toPositionList(boolean compressed) {
        return ImmutableList.builder().addAll(InputStreamCheckpoint.createInputStreamPositionList(compressed, this.inputStreamCheckpoint)).add((Object)this.offset).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.offset).add("inputStreamCheckpoint", (Object)InputStreamCheckpoint.inputStreamCheckpointToString(this.inputStreamCheckpoint)).toString();
    }
}

