/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.BinaryColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.BooleanColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DateColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DecimalColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.MapStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.facebook.presto.orc.metadata.statistics.StringColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class ColumnStatistics
implements StatisticsHasher.Hashable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ColumnStatistics.class).instanceSize();
    private final boolean hasNumberOfValues;
    private final long numberOfValues;
    private final HiveBloomFilter bloomFilter;

    public ColumnStatistics(Long numberOfValues) {
        this(numberOfValues, null);
    }

    public ColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter) {
        this.hasNumberOfValues = numberOfValues != null;
        this.numberOfValues = this.hasNumberOfValues ? numberOfValues : 0L;
        this.bloomFilter = bloomFilter;
    }

    public boolean hasNumberOfValues() {
        return this.hasNumberOfValues;
    }

    public long getNumberOfValues() {
        return this.hasNumberOfValues ? this.numberOfValues : 0L;
    }

    public boolean hasMinAverageValueSizeInBytes() {
        return this.hasNumberOfValues() && this.numberOfValues > 0L;
    }

    public long getTotalValueSizeInBytes() {
        return 0L;
    }

    public BooleanStatistics getBooleanStatistics() {
        return null;
    }

    public DateStatistics getDateStatistics() {
        return null;
    }

    public DoubleStatistics getDoubleStatistics() {
        return null;
    }

    public IntegerStatistics getIntegerStatistics() {
        return null;
    }

    public StringStatistics getStringStatistics() {
        return null;
    }

    public DecimalStatistics getDecimalStatistics() {
        return null;
    }

    public BinaryStatistics getBinaryStatistics() {
        return null;
    }

    public MapStatistics getMapStatistics() {
        return null;
    }

    public HiveBloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public ColumnStatistics withBloomFilter(HiveBloomFilter bloomFilter) {
        return new ColumnStatistics(this.getNumberOfValues(), bloomFilter);
    }

    protected final long getMembersSizeInBytes() {
        return this.bloomFilter == null ? 0L : this.bloomFilter.getRetainedSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getMembersSizeInBytes();
    }

    protected final boolean equalsInternal(ColumnStatistics that) {
        return this.hasNumberOfValues == that.hasNumberOfValues && this.numberOfValues == that.numberOfValues && Objects.equals(this.getBloomFilter(), that.getBloomFilter());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatistics that = (ColumnStatistics)o;
        return this.equalsInternal(that);
    }

    public int hashCode() {
        return Objects.hash(this.hasNumberOfValues, this.getNumberOfValues(), this.getBloomFilter());
    }

    protected MoreObjects.ToStringHelper getToStringHelper() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("numberOfValues", this.getNumberOfValues()).add("bloomFilter", (Object)this.getBloomFilter());
    }

    public String toString() {
        return this.getToStringHelper().toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putOptionalLong(this.hasNumberOfValues, this.numberOfValues).putOptionalHashable(this.getBloomFilter());
    }

    public static ColumnStatistics mergeColumnStatistics(List<ColumnStatistics> stats) {
        if (stats.isEmpty()) {
            return new ColumnStatistics(0L, null);
        }
        long numberOfRows = stats.stream().mapToLong(ColumnStatistics::getNumberOfValues).sum();
        return ColumnStatistics.createColumnStatistics(numberOfRows, BooleanStatisticsBuilder.mergeBooleanStatistics(stats).orElse(null), IntegerStatisticsBuilder.mergeIntegerStatistics(stats).orElse(null), DoubleStatisticsBuilder.mergeDoubleStatistics(stats).orElse(null), StringStatisticsBuilder.mergeStringStatistics(stats).orElse(null), DateStatisticsBuilder.mergeDateStatistics(stats).orElse(null), LongDecimalStatisticsBuilder.mergeDecimalStatistics(stats).orElse(null), BinaryStatisticsBuilder.mergeBinaryStatistics(stats).orElse(null), MapColumnStatisticsBuilder.mergeMapStatistics(stats).orElse(null), null);
    }

    public static ColumnStatistics createColumnStatistics(Long numberOfValues, BooleanStatistics booleanStatistics, IntegerStatistics integerStatistics, DoubleStatistics doubleStatistics, StringStatistics stringStatistics, DateStatistics dateStatistics, DecimalStatistics decimalStatistics, BinaryStatistics binaryStatistics, MapStatistics mapStatistics, HiveBloomFilter bloomFilter) {
        if (booleanStatistics != null) {
            return new BooleanColumnStatistics(numberOfValues, bloomFilter, booleanStatistics);
        }
        if (integerStatistics != null) {
            return new IntegerColumnStatistics(numberOfValues, bloomFilter, integerStatistics);
        }
        if (doubleStatistics != null) {
            return new DoubleColumnStatistics(numberOfValues, bloomFilter, doubleStatistics);
        }
        if (stringStatistics != null) {
            return new StringColumnStatistics(numberOfValues, bloomFilter, stringStatistics);
        }
        if (dateStatistics != null) {
            return new DateColumnStatistics(numberOfValues, bloomFilter, dateStatistics);
        }
        if (decimalStatistics != null) {
            return new DecimalColumnStatistics(numberOfValues, bloomFilter, decimalStatistics);
        }
        if (binaryStatistics != null) {
            return new BinaryColumnStatistics(numberOfValues, bloomFilter, binaryStatistics);
        }
        if (mapStatistics != null) {
            return new MapColumnStatistics(numberOfValues, bloomFilter, mapStatistics);
        }
        return new ColumnStatistics(numberOfValues, bloomFilter);
    }
}

