/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.metadata.statistics.BooleanColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BooleanStatisticsBuilder
implements StatisticsBuilder {
    private long nonNullValueCount;
    private long trueValueCount;

    @Override
    public void addBlock(Type type, Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            this.addValue(type.getBoolean(block, position));
        }
    }

    public void addValue(boolean value) {
        ++this.nonNullValueCount;
        if (value) {
            ++this.trueValueCount;
        }
    }

    private void addBooleanStatistics(long valueCount, BooleanStatistics value) {
        Objects.requireNonNull(value, "value is null");
        this.nonNullValueCount += valueCount;
        this.trueValueCount += value.getTrueValueCount();
    }

    private Optional<BooleanStatistics> buildBooleanStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new BooleanStatistics(this.trueValueCount));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<BooleanStatistics> booleanStatistics = this.buildBooleanStatistics();
        if (booleanStatistics.isPresent()) {
            return new BooleanColumnStatistics(this.nonNullValueCount, null, booleanStatistics.get());
        }
        return new ColumnStatistics(this.nonNullValueCount, null);
    }

    public static Optional<BooleanStatistics> mergeBooleanStatistics(List<ColumnStatistics> stats) {
        BooleanStatisticsBuilder booleanStatisticsBuilder = new BooleanStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            BooleanStatistics partialStatistics = columnStatistics.getBooleanStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            booleanStatisticsBuilder.addBooleanStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return booleanStatisticsBuilder.buildBooleanStatistics();
    }
}

