/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class StripeInformation {
    private final long numberOfRows;
    private final long offset;
    private final long indexLength;
    private final long dataLength;
    private final long footerLength;
    private final OptionalLong rawDataSize;
    private final List<byte[]> keyMetadata;

    public StripeInformation(long numberOfRows, long offset, long indexLength, long dataLength, long footerLength, OptionalLong rawDataSize, List<byte[]> keyMetadata) {
        Preconditions.checkArgument((numberOfRows > 0L ? 1 : 0) != 0, (Object)"Stripe must have at least one row");
        Preconditions.checkArgument((footerLength > 0L ? 1 : 0) != 0, (Object)"Stripe must have a footer section");
        Objects.requireNonNull(keyMetadata, "keyMetadata is null");
        this.numberOfRows = numberOfRows;
        this.offset = offset;
        this.indexLength = indexLength;
        this.dataLength = dataLength;
        this.footerLength = footerLength;
        this.rawDataSize = Objects.requireNonNull(rawDataSize, "rawDataSize is null");
        this.keyMetadata = ImmutableList.copyOf((Collection)Objects.requireNonNull(keyMetadata, "keyMetadata is null"));
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getIndexLength() {
        return this.indexLength;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public long getFooterLength() {
        return this.footerLength;
    }

    public long getTotalLength() {
        return this.indexLength + this.dataLength + this.footerLength;
    }

    public OptionalLong getRawDataSize() {
        return this.rawDataSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRows", this.numberOfRows).add("offset", this.offset).add("indexLength", this.indexLength).add("dataLength", this.dataLength).add("footerLength", this.footerLength).toString();
    }

    public List<byte[]> getKeyMetadata() {
        return this.keyMetadata;
    }
}

