/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.DwrfStripeCache;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DwrfStripeCacheData {
    private final Slice cacheSlice;
    private final int cacheSliceSize;
    private final DwrfStripeCacheMode mode;

    public DwrfStripeCacheData(Slice stripeCacheSlice, int stripeCacheSize, DwrfStripeCacheMode stripeCacheMode) {
        this.cacheSlice = Objects.requireNonNull(stripeCacheSlice, "stripeCacheSlice is null");
        this.cacheSliceSize = stripeCacheSize;
        this.mode = Objects.requireNonNull(stripeCacheMode, "stripeCacheMode is null");
    }

    public Slice getDwrfStripeCacheSlice() {
        return this.cacheSlice;
    }

    public int getDwrfStripeCacheSize() {
        return this.cacheSliceSize;
    }

    public DwrfStripeCacheMode getDwrfStripeCacheMode() {
        return this.mode;
    }

    public DwrfStripeCache buildDwrfStripeCache(List<StripeInformation> stripes, List<Integer> cacheOffsets) {
        ArrayList<StripeInformation> sortedStripes = new ArrayList<StripeInformation>(stripes);
        sortedStripes.sort(Comparator.comparingLong(StripeInformation::getOffset));
        ImmutableMap.Builder indexSlices = ImmutableMap.builder();
        if (this.mode.hasIndex()) {
            int offsetIdx;
            for (int i = 0; i < sortedStripes.size() && this.isValidCacheOffset(offsetIdx = this.mode.getIndexOffsetPosition(i), cacheOffsets); ++i) {
                this.addSlice(offsetIdx, cacheOffsets, (ImmutableMap.Builder<Long, Slice>)indexSlices, (StripeInformation)sortedStripes.get(i));
            }
        }
        ImmutableMap.Builder footerSlices = ImmutableMap.builder();
        if (this.mode.hasFooter()) {
            int offsetIdx;
            for (int i = 0; i < sortedStripes.size() && this.isValidCacheOffset(offsetIdx = this.mode.getFooterOffsetPosition(i), cacheOffsets); ++i) {
                this.addSlice(offsetIdx, cacheOffsets, (ImmutableMap.Builder<Long, Slice>)footerSlices, (StripeInformation)sortedStripes.get(i));
            }
        }
        return new DwrfStripeCache(this.mode, (Map<Long, Slice>)indexSlices.build(), (Map<Long, Slice>)footerSlices.build());
    }

    private boolean isValidCacheOffset(int cacheOffsetIdx, List<Integer> cacheOffsets) {
        return cacheOffsetIdx + 1 < cacheOffsets.size();
    }

    private void addSlice(int cacheOffsetIdx, List<Integer> cacheOffsets, ImmutableMap.Builder<Long, Slice> slices, StripeInformation stripe) {
        int sliceOffset = cacheOffsets.get(cacheOffsetIdx);
        int sliceSize = cacheOffsets.get(cacheOffsetIdx + 1) - sliceOffset;
        Preconditions.checkState((sliceOffset < this.cacheSlice.length() ? 1 : 0) != 0, (String)"stripe cache offset %s is out of bound for cache slice of size %s", (int)sliceOffset, (int)this.cacheSlice.length());
        Preconditions.checkState((sliceOffset + sliceSize <= this.cacheSlice.length() ? 1 : 0) != 0, (String)"stripe cache offset+size=%s is out of bound for cache slice of size %s", (int)(sliceOffset + sliceSize), (int)this.cacheSlice.length());
        slices.put((Object)stripe.getOffset(), (Object)this.cacheSlice.slice(sliceOffset, sliceSize));
    }
}

