/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.NoopOrcLocalMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfEncryption;
import com.facebook.presto.orc.metadata.DwrfMetadataWriter;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.metadata.EncryptionGroup;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.KeyProvider;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeEncryptionGroup;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.MapStatistics;
import com.facebook.presto.orc.metadata.statistics.MapStatisticsEntry;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.facebook.presto.orc.protobuf.CodedInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.sun.management.ThreadMXBean;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.SortedMap;
import java.util.stream.IntStream;

public class DwrfMetadataReader
implements MetadataReader {
    private static final ThreadMXBean THREAD_MX_BEAN = (ThreadMXBean)ManagementFactory.getThreadMXBean();
    private final RuntimeStats runtimeStats;
    private final boolean readMapStatistics;

    public DwrfMetadataReader(RuntimeStats runtimeStats, OrcReaderOptions readerOptions) {
        this.runtimeStats = Objects.requireNonNull(runtimeStats, "runtimeStats is null");
        Objects.requireNonNull(readerOptions, "readerOptions is null");
        this.readMapStatistics = readerOptions.readMapStatistics();
    }

    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws IOException {
        long cpuStart = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        CodedInputStream input = CodedInputStream.newInstance((byte[])data, (int)offset, (int)length);
        DwrfProto.PostScript postScript = DwrfProto.PostScript.parseFrom((CodedInputStream)input);
        PostScript.HiveWriterVersion writerVersion = postScript.hasWriterVersion() && postScript.getWriterVersion() > 0 ? PostScript.HiveWriterVersion.ORC_HIVE_8732 : PostScript.HiveWriterVersion.ORIGINAL;
        OptionalInt stripeCacheLength = OptionalInt.empty();
        Optional<DwrfStripeCacheMode> stripeCacheMode = Optional.empty();
        if (postScript.hasCacheSize() && postScript.hasCacheMode()) {
            stripeCacheLength = OptionalInt.of(postScript.getCacheSize());
            stripeCacheMode = Optional.of(DwrfMetadataReader.toStripeCacheMode(postScript.getCacheMode()));
        }
        this.runtimeStats.addMetricValue("DwrfReadPostScriptTimeNanos", RuntimeUnit.NANO, THREAD_MX_BEAN.getCurrentThreadCpuTime() - cpuStart);
        return new PostScript((List<Integer>)ImmutableList.of(), postScript.getFooterLength(), 0L, DwrfMetadataReader.toCompression(postScript.getCompression()), postScript.getCompressionBlockSize(), writerVersion, stripeCacheLength, stripeCacheMode);
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) {
        return new Metadata((List<StripeStatistics>)ImmutableList.of());
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream, DwrfEncryptionProvider dwrfEncryptionProvider, DwrfKeyProvider dwrfKeyProvider, OrcDataSource orcDataSource, Optional<OrcDecompressor> decompressor) throws IOException {
        long cpuStart = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        DwrfProto.Footer footer = DwrfProto.Footer.parseFrom((CodedInputStream)input);
        List<ColumnStatistics> fileStats = this.toColumnStatistics(hiveWriterVersion, footer.getStatisticsList(), false);
        List<StripeInformation> fileStripes = DwrfMetadataReader.toStripeInformation(footer.getStripesList());
        List<OrcType> types = DwrfMetadataReader.toType(footer.getTypesList());
        Optional<DwrfEncryption> encryption = footer.hasEncryption() ? Optional.of(DwrfMetadataReader.toEncryption(footer.getEncryption())) : Optional.empty();
        Optional<List<Integer>> stripeCacheOffsets = Optional.of(footer.getStripeCacheOffsetsList());
        if (encryption.isPresent()) {
            Map<Integer, Slice> keys = dwrfKeyProvider.getIntermediateKeys(types);
            EncryptionLibrary encryptionLibrary = dwrfEncryptionProvider.getEncryptionLibrary(((DwrfEncryption)encryption.get()).getKeyProvider());
            fileStats = this.decryptAndCombineFileStatistics(hiveWriterVersion, (DwrfEncryption)encryption.get(), encryptionLibrary, fileStats, fileStripes, keys, orcDataSource, decompressor);
        }
        this.runtimeStats.addMetricValue("DwrfReadFooterTimeNanos", RuntimeUnit.NANO, THREAD_MX_BEAN.getCurrentThreadCpuTime() - cpuStart);
        OptionalLong rawSize = footer.hasRawDataSize() ? OptionalLong.of(footer.getRawDataSize()) : OptionalLong.empty();
        return new Footer(footer.getNumberOfRows(), footer.getRowIndexStride(), rawSize, fileStripes, types, fileStats, this.toUserMetadata(footer.getMetadataList()), encryption, stripeCacheOffsets);
    }

    private List<ColumnStatistics> decryptAndCombineFileStatistics(PostScript.HiveWriterVersion hiveWriterVersion, DwrfEncryption dwrfEncryption, EncryptionLibrary encryptionLibrary, List<ColumnStatistics> fileStats, List<StripeInformation> fileStripes, Map<Integer, Slice> nodeToIntermediateKeys, OrcDataSource orcDataSource, Optional<OrcDecompressor> decompressor) {
        Objects.requireNonNull(dwrfEncryption, "dwrfEncryption is null");
        Objects.requireNonNull(encryptionLibrary, "encryptionLibrary is null");
        if (nodeToIntermediateKeys.isEmpty() || fileStats.isEmpty()) {
            return fileStats;
        }
        Object[] decryptedFileStats = fileStats.toArray(new ColumnStatistics[0]);
        List<EncryptionGroup> encryptionGroups = dwrfEncryption.getEncryptionGroups();
        List<byte[]> stripeKeys = null;
        if (!fileStripes.isEmpty() && !fileStripes.get(0).getKeyMetadata().isEmpty()) {
            stripeKeys = fileStripes.get(0).getKeyMetadata();
            Preconditions.checkState((stripeKeys.size() == encryptionGroups.size() ? 1 : 0) != 0, (Object)"Number of keys in the first stripe must be the same as the number of encryption groups");
        }
        for (int groupIdx = 0; groupIdx < encryptionGroups.size(); ++groupIdx) {
            EncryptionGroup encryptionGroup = encryptionGroups.get(groupIdx);
            DwrfDataEncryptor decryptor = null;
            List<Integer> nodes = encryptionGroup.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                Integer nodeId = nodes.get(i);
                if (!nodeToIntermediateKeys.containsKey(nodeId)) continue;
                if (decryptor == null) {
                    byte[] encryptedDataKeyWithMeta = null;
                    if (encryptionGroup.getKeyMetadata().isPresent()) {
                        encryptedDataKeyWithMeta = encryptionGroup.getKeyMetadata().get().byteArray();
                    } else if (stripeKeys != null) {
                        encryptedDataKeyWithMeta = stripeKeys.get(groupIdx);
                    }
                    Preconditions.checkState((encryptedDataKeyWithMeta != null ? 1 : 0) != 0, (String)"DEK for %s encryption group is null", (int)groupIdx);
                    byte[] intermediateKey = nodeToIntermediateKeys.get(nodeId).byteArray();
                    byte[] dataKey = encryptionLibrary.decryptKey(intermediateKey, encryptedDataKeyWithMeta, 0, encryptedDataKeyWithMeta.length);
                    decryptor = new DwrfDataEncryptor(dataKey, encryptionLibrary);
                }
                Slice encryptedFileStats = encryptionGroup.getStatistics().get(i);
                try (OrcInputStream inputStream = new OrcInputStream(orcDataSource.getId(), new SharedBuffer(NoopOrcLocalMemoryContext.NOOP_ORC_LOCAL_MEMORY_CONTEXT), (FixedLengthSliceInput)new BasicSliceInput(encryptedFileStats), decompressor, Optional.of(decryptor), NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, encryptedFileStats.length());){
                    CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
                    DwrfProto.FileStatistics nodeStats = DwrfProto.FileStatistics.parseFrom((CodedInputStream)input);
                    for (int statsIdx = 0; statsIdx < nodeStats.getStatisticsCount(); ++statsIdx) {
                        decryptedFileStats[nodeId.intValue() + statsIdx] = this.toColumnStatistics(hiveWriterVersion, nodeStats.getStatistics(statsIdx), false, null);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new OrcCorruptionException(e, orcDataSource.getId(), "Failed to read or decrypt FileStatistics for node %s", nodeId);
                }
            }
        }
        return ImmutableList.copyOf((Object[])decryptedFileStats);
    }

    private static DwrfEncryption toEncryption(DwrfProto.Encryption encryption) {
        KeyProvider keyProvider = DwrfMetadataReader.toKeyProvider(encryption.getKeyProvider());
        List<EncryptionGroup> encryptionGroups = DwrfMetadataReader.toEncryptionGroups(encryption.getEncryptionGroupsList());
        return new DwrfEncryption(keyProvider, encryptionGroups);
    }

    private static List<EncryptionGroup> toEncryptionGroups(List<DwrfProto.EncryptionGroup> encryptionGroups) {
        ImmutableList.Builder encryptionGroupBuilder = ImmutableList.builderWithExpectedSize((int)encryptionGroups.size());
        for (DwrfProto.EncryptionGroup dwrfEncryptionGroup : encryptionGroups) {
            encryptionGroupBuilder.add((Object)new EncryptionGroup(dwrfEncryptionGroup.getNodesList(), dwrfEncryptionGroup.hasKeyMetadata() ? Optional.of(OrcMetadataReader.byteStringToSlice(dwrfEncryptionGroup.getKeyMetadata())) : Optional.empty(), (List)dwrfEncryptionGroup.getStatisticsList().stream().map(OrcMetadataReader::byteStringToSlice).collect(ImmutableList.toImmutableList())));
        }
        return encryptionGroupBuilder.build();
    }

    private static KeyProvider toKeyProvider(DwrfProto.Encryption.KeyProvider keyProvider) {
        switch (keyProvider) {
            case CRYPTO_SERVICE: {
                return KeyProvider.CRYPTO_SERVICE;
            }
        }
        return KeyProvider.UNKNOWN;
    }

    private static List<StripeInformation> toStripeInformation(List<DwrfProto.StripeInformation> stripeInformationList) {
        ImmutableList.Builder stripeInfoBuilder = ImmutableList.builderWithExpectedSize((int)stripeInformationList.size());
        Object previousKeyMetadata = ImmutableList.of();
        for (DwrfProto.StripeInformation dwrfStripeInfo : stripeInformationList) {
            StripeInformation prestoStripeInfo = DwrfMetadataReader.toStripeInformation(dwrfStripeInfo, (List<byte[]>)previousKeyMetadata);
            stripeInfoBuilder.add((Object)prestoStripeInfo);
            previousKeyMetadata = prestoStripeInfo.getKeyMetadata();
        }
        return stripeInfoBuilder.build();
    }

    private static StripeInformation toStripeInformation(DwrfProto.StripeInformation stripeInformation, List<byte[]> previousKeyMetadata) {
        List<byte[]> keyMetadata = (List<byte[]>)stripeInformation.getKeyMetadataList().stream().map(ByteString::toByteArray).collect(ImmutableList.toImmutableList());
        if (keyMetadata.isEmpty()) {
            keyMetadata = previousKeyMetadata;
        }
        OptionalLong rawDataSize = stripeInformation.hasRawDataSize() ? OptionalLong.of(stripeInformation.getRawDataSize()) : OptionalLong.empty();
        return new StripeInformation(stripeInformation.getNumberOfRows(), stripeInformation.getOffset(), stripeInformation.getIndexLength(), stripeInformation.getDataLength(), stripeInformation.getFooterLength(), rawDataSize, keyMetadata);
    }

    @Override
    public StripeFooter readStripeFooter(OrcDataSourceId orcDataSourceId, List<OrcType> types, InputStream inputStream) throws IOException {
        long cpuStart = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        DwrfProto.StripeFooter stripeFooter = DwrfProto.StripeFooter.parseFrom((CodedInputStream)input);
        this.runtimeStats.addMetricValue("DwrfReadStripeFooterTimeNanos", RuntimeUnit.NANO, THREAD_MX_BEAN.getCurrentThreadCpuTime() - cpuStart);
        return new StripeFooter(DwrfMetadataReader.toStream(orcDataSourceId, stripeFooter.getStreamsList()), DwrfMetadataReader.toColumnEncoding(types, (List<DwrfProto.ColumnEncoding>)stripeFooter.getColumnsList()), (List)stripeFooter.getEncryptedGroupsList().stream().map(OrcMetadataReader::byteStringToSlice).collect(ImmutableList.toImmutableList()));
    }

    private static Stream toStream(OrcDataSourceId orcDataSourceId, DwrfProto.Stream stream) {
        if (stream.getLength() > Integer.MAX_VALUE) {
            throw new OrcCorruptionException(orcDataSourceId, "Stream size %s of one of the streams for column %s is larger than supported size %s", stream.getLength(), stream.getColumn(), Integer.MAX_VALUE);
        }
        return new Stream(stream.getColumn(), DwrfMetadataReader.toStreamKind(stream.getKind()), Math.toIntExact(stream.getLength()), stream.getUseVInts(), stream.getSequence(), stream.hasOffset() ? Optional.of(stream.getOffset()) : Optional.empty());
    }

    private static List<Stream> toStream(OrcDataSourceId orcDataSourceId, List<DwrfProto.Stream> streams) {
        return (List)streams.stream().map(stream -> DwrfMetadataReader.toStream(orcDataSourceId, stream)).collect(ImmutableList.toImmutableList());
    }

    private static DwrfSequenceEncoding toSequenceEncoding(OrcType type, DwrfProto.ColumnEncoding columnEncoding) {
        return new DwrfSequenceEncoding(columnEncoding.getKey(), new ColumnEncoding(DwrfMetadataReader.toColumnEncodingKind(type.getOrcTypeKind(), columnEncoding.getKind()), columnEncoding.getDictionarySize()));
    }

    private static ColumnEncoding toColumnEncoding(OrcType type, List<DwrfProto.ColumnEncoding> columnEncodings) {
        Optional<SortedMap<Integer, DwrfSequenceEncoding>> nonZeroEncodingsOptional;
        DwrfProto.ColumnEncoding sequence0 = null;
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (DwrfProto.ColumnEncoding columnEncoding : columnEncodings) {
            if (columnEncoding.getSequence() == 0) {
                sequence0 = columnEncoding;
                continue;
            }
            builder.put((Object)columnEncoding.getSequence(), (Object)DwrfMetadataReader.toSequenceEncoding(type, columnEncoding));
        }
        ImmutableSortedMap nonZeroSequences = builder.build();
        Optional<Object> optional = nonZeroEncodingsOptional = nonZeroSequences.isEmpty() ? Optional.empty() : Optional.of(nonZeroSequences);
        if (sequence0 != null) {
            return new ColumnEncoding(DwrfMetadataReader.toColumnEncodingKind(type.getOrcTypeKind(), sequence0.getKind()), sequence0.getDictionarySize(), nonZeroEncodingsOptional);
        }
        return new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT, 0, nonZeroEncodingsOptional);
    }

    private static Map<Integer, ColumnEncoding> toColumnEncoding(List<OrcType> types, List<DwrfProto.ColumnEncoding> columnEncodings) {
        HashMap<Integer, List> groupedColumnEncodings = new HashMap<Integer, List>(columnEncodings.size());
        for (int i = 0; i < columnEncodings.size(); ++i) {
            DwrfProto.ColumnEncoding columnEncoding = columnEncodings.get(i);
            int column = columnEncoding.getColumn();
            if (!columnEncoding.hasColumn()) {
                column = i;
            }
            groupedColumnEncodings.computeIfAbsent(column, key -> new ArrayList()).add(columnEncoding);
        }
        ImmutableMap.Builder resultBuilder = ImmutableMap.builderWithExpectedSize((int)groupedColumnEncodings.size());
        for (Map.Entry entry : groupedColumnEncodings.entrySet()) {
            OrcType type = types.get((Integer)entry.getKey());
            resultBuilder.put(entry.getKey(), (Object)DwrfMetadataReader.toColumnEncoding(type, (List<DwrfProto.ColumnEncoding>)((List)entry.getValue())));
        }
        return resultBuilder.build();
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream, List<HiveBloomFilter> bloomFilters) throws IOException {
        long cpuStart = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        DwrfProto.RowIndex rowIndex = DwrfProto.RowIndex.parseFrom((CodedInputStream)input);
        this.runtimeStats.addMetricValue("DwrfReadRowIndexesTimeNanos", RuntimeUnit.NANO, THREAD_MX_BEAN.getCurrentThreadCpuTime() - cpuStart);
        return (List)IntStream.range(0, rowIndex.getEntryCount()).mapToObj(i -> this.toRowGroupIndex(hiveWriterVersion, rowIndex.getEntry(i), bloomFilters == null || bloomFilters.isEmpty() ? null : (HiveBloomFilter)bloomFilters.get(i))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<HiveBloomFilter> readBloomFilterIndexes(InputStream inputStream) {
        return ImmutableList.of();
    }

    private RowGroupIndex toRowGroupIndex(PostScript.HiveWriterVersion hiveWriterVersion, DwrfProto.RowIndexEntry rowIndexEntry, HiveBloomFilter bloomFilter) {
        List positionsList = rowIndexEntry.getPositionsList();
        ImmutableList.Builder positions = ImmutableList.builderWithExpectedSize((int)positionsList.size());
        for (int index = 0; index < positionsList.size(); ++index) {
            long longPosition = (Long)positionsList.get(index);
            int intPosition = (int)longPosition;
            Preconditions.checkState(((long)intPosition == longPosition ? 1 : 0) != 0, (String)"Expected checkpoint position %s, to be an integer", (int)index);
            positions.add((Object)intPosition);
        }
        return new RowGroupIndex((List<Integer>)positions.build(), this.toColumnStatistics(hiveWriterVersion, rowIndexEntry.getStatistics(), true, bloomFilter));
    }

    private List<ColumnStatistics> toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, List<DwrfProto.ColumnStatistics> columnStatistics, boolean isRowGroup) {
        if (columnStatistics == null) {
            return ImmutableList.of();
        }
        return (List)columnStatistics.stream().map(statistics -> this.toColumnStatistics(hiveWriterVersion, (DwrfProto.ColumnStatistics)statistics, isRowGroup, null)).collect(ImmutableList.toImmutableList());
    }

    private Map<String, Slice> toUserMetadata(List<DwrfProto.UserMetadataItem> metadataList) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (DwrfProto.UserMetadataItem item : metadataList) {
            if (DwrfMetadataWriter.STATIC_METADATA.containsKey(item.getName())) continue;
            mapBuilder.put((Object)item.getName(), (Object)OrcMetadataReader.byteStringToSlice(item.getValue()));
        }
        return mapBuilder.build();
    }

    @VisibleForTesting
    ColumnStatistics toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, DwrfProto.ColumnStatistics statistics, boolean isRowGroup, HiveBloomFilter bloomFilter) {
        return ColumnStatistics.createColumnStatistics(statistics.getNumberOfValues(), statistics.hasBucketStatistics() ? DwrfMetadataReader.toBooleanStatistics(statistics.getBucketStatistics()) : null, statistics.hasIntStatistics() ? DwrfMetadataReader.toIntegerStatistics(statistics.getIntStatistics()) : null, statistics.hasDoubleStatistics() ? DwrfMetadataReader.toDoubleStatistics(statistics.getDoubleStatistics()) : null, statistics.hasStringStatistics() ? DwrfMetadataReader.toStringStatistics(hiveWriterVersion, statistics.getStringStatistics(), isRowGroup) : null, null, null, statistics.hasBinaryStatistics() ? DwrfMetadataReader.toBinaryStatistics(statistics.getBinaryStatistics()) : null, this.readMapStatistics && statistics.hasMapStatistics() ? this.toMapStatistics(statistics.getMapStatistics(), hiveWriterVersion, isRowGroup, bloomFilter) : null, bloomFilter);
    }

    private static BooleanStatistics toBooleanStatistics(DwrfProto.BucketStatistics bucketStatistics) {
        if (bucketStatistics.getCountCount() == 0) {
            return null;
        }
        return new BooleanStatistics(bucketStatistics.getCount(0));
    }

    private static IntegerStatistics toIntegerStatistics(DwrfProto.IntegerStatistics integerStatistics) {
        return new IntegerStatistics(integerStatistics.hasMinimum() ? Long.valueOf(integerStatistics.getMinimum()) : null, integerStatistics.hasMaximum() ? Long.valueOf(integerStatistics.getMaximum()) : null, integerStatistics.hasSum() ? Long.valueOf(integerStatistics.getSum()) : null);
    }

    private static DoubleStatistics toDoubleStatistics(DwrfProto.DoubleStatistics doubleStatistics) {
        if (doubleStatistics.hasMinimum() && Double.isNaN(doubleStatistics.getMinimum()) || doubleStatistics.hasMaximum() && Double.isNaN(doubleStatistics.getMaximum()) || doubleStatistics.hasSum() && Double.isNaN(doubleStatistics.getSum())) {
            return null;
        }
        return new DoubleStatistics(doubleStatistics.hasMinimum() ? Double.valueOf(doubleStatistics.getMinimum()) : null, doubleStatistics.hasMaximum() ? Double.valueOf(doubleStatistics.getMaximum()) : null);
    }

    @VisibleForTesting
    static StringStatistics toStringStatistics(PostScript.HiveWriterVersion hiveWriterVersion, DwrfProto.StringStatistics stringStatistics, boolean isRowGroup) {
        if (hiveWriterVersion == PostScript.HiveWriterVersion.ORIGINAL && !isRowGroup) {
            return null;
        }
        Slice maximum = stringStatistics.hasMaximum() ? OrcMetadataReader.maxStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMaximumBytes()), hiveWriterVersion) : null;
        Slice minimum = stringStatistics.hasMinimum() ? OrcMetadataReader.minStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMinimumBytes()), hiveWriterVersion) : null;
        long sum = stringStatistics.hasSum() ? stringStatistics.getSum() : 0L;
        return new StringStatistics(minimum, maximum, sum);
    }

    private static BinaryStatistics toBinaryStatistics(DwrfProto.BinaryStatistics binaryStatistics) {
        if (!binaryStatistics.hasSum()) {
            return null;
        }
        return new BinaryStatistics(binaryStatistics.getSum());
    }

    private MapStatistics toMapStatistics(DwrfProto.MapStatistics mapStatistics, PostScript.HiveWriterVersion hiveWriterVersion, boolean isRowGroup, HiveBloomFilter bloomFilter) {
        ImmutableList.Builder mapStatisticsEntries = ImmutableList.builderWithExpectedSize((int)mapStatistics.getStatsCount());
        for (DwrfProto.MapEntryStatistics mapEntryStatistics : mapStatistics.getStatsList()) {
            DwrfProto.ColumnStatistics dwrfStatistics = mapEntryStatistics.getStats();
            ColumnStatistics columnStatistics = this.toColumnStatistics(hiveWriterVersion, dwrfStatistics, isRowGroup, bloomFilter);
            DwrfProto.KeyInfo key = mapEntryStatistics.getKey();
            mapStatisticsEntries.add((Object)new MapStatisticsEntry(key, columnStatistics));
        }
        return new MapStatistics((List<MapStatisticsEntry>)mapStatisticsEntries.build());
    }

    private static OrcType toType(DwrfProto.Type type) {
        return new OrcType(DwrfMetadataReader.toTypeKind(type.getKind()), type.getSubtypesList(), (List<String>)type.getFieldNamesList(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static List<OrcType> toType(List<DwrfProto.Type> types) {
        return (List)types.stream().map(DwrfMetadataReader::toType).collect(ImmutableList.toImmutableList());
    }

    private static OrcType.OrcTypeKind toTypeKind(DwrfProto.Type.Kind kind) {
        switch (kind) {
            case BOOLEAN: {
                return OrcType.OrcTypeKind.BOOLEAN;
            }
            case BYTE: {
                return OrcType.OrcTypeKind.BYTE;
            }
            case SHORT: {
                return OrcType.OrcTypeKind.SHORT;
            }
            case INT: {
                return OrcType.OrcTypeKind.INT;
            }
            case LONG: {
                return OrcType.OrcTypeKind.LONG;
            }
            case FLOAT: {
                return OrcType.OrcTypeKind.FLOAT;
            }
            case DOUBLE: {
                return OrcType.OrcTypeKind.DOUBLE;
            }
            case STRING: {
                return OrcType.OrcTypeKind.STRING;
            }
            case BINARY: {
                return OrcType.OrcTypeKind.BINARY;
            }
            case TIMESTAMP: {
                return OrcType.OrcTypeKind.TIMESTAMP;
            }
            case LIST: {
                return OrcType.OrcTypeKind.LIST;
            }
            case MAP: {
                return OrcType.OrcTypeKind.MAP;
            }
            case STRUCT: {
                return OrcType.OrcTypeKind.STRUCT;
            }
            case UNION: {
                return OrcType.OrcTypeKind.UNION;
            }
        }
        throw new IllegalArgumentException(kind + " data type not implemented yet");
    }

    private static Stream.StreamKind toStreamKind(DwrfProto.Stream.Kind kind) {
        switch (kind) {
            case PRESENT: {
                return Stream.StreamKind.PRESENT;
            }
            case DATA: {
                return Stream.StreamKind.DATA;
            }
            case LENGTH: {
                return Stream.StreamKind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return Stream.StreamKind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return Stream.StreamKind.DICTIONARY_COUNT;
            }
            case NANO_DATA: {
                return Stream.StreamKind.SECONDARY;
            }
            case ROW_INDEX: {
                return Stream.StreamKind.ROW_INDEX;
            }
            case IN_DICTIONARY: {
                return Stream.StreamKind.IN_DICTIONARY;
            }
            case STRIDE_DICTIONARY: {
                return Stream.StreamKind.ROW_GROUP_DICTIONARY;
            }
            case STRIDE_DICTIONARY_LENGTH: {
                return Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH;
            }
            case IN_MAP: {
                return Stream.StreamKind.IN_MAP;
            }
        }
        throw new IllegalArgumentException(kind + " stream type not implemented yet");
    }

    private static ColumnEncoding.ColumnEncodingKind toColumnEncodingKind(OrcType.OrcTypeKind type, DwrfProto.ColumnEncoding.Kind kind) {
        switch (kind) {
            case DIRECT: {
                if (type == OrcType.OrcTypeKind.SHORT || type == OrcType.OrcTypeKind.INT || type == OrcType.OrcTypeKind.LONG) {
                    return ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT;
                }
                return ColumnEncoding.ColumnEncodingKind.DIRECT;
            }
            case DICTIONARY: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY;
            }
            case MAP_FLAT: {
                return ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT;
            }
        }
        throw new IllegalArgumentException(kind + " stream encoding not implemented yet");
    }

    private static CompressionKind toCompression(DwrfProto.CompressionKind compression) {
        switch (compression) {
            case NONE: {
                return CompressionKind.NONE;
            }
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
            case LZ4: {
                return CompressionKind.LZ4;
            }
            case ZSTD: {
                return CompressionKind.ZSTD;
            }
        }
        throw new IllegalArgumentException(compression + " compression not implemented yet");
    }

    static DwrfStripeCacheMode toStripeCacheMode(DwrfProto.StripeCacheMode mode) {
        switch (mode) {
            case INDEX: {
                return DwrfStripeCacheMode.INDEX;
            }
            case FOOTER: {
                return DwrfStripeCacheMode.FOOTER;
            }
            case BOTH: {
                return DwrfStripeCacheMode.INDEX_AND_FOOTER;
            }
        }
        return DwrfStripeCacheMode.NONE;
    }

    public static StripeEncryptionGroup toStripeEncryptionGroup(OrcDataSourceId orcDataSourceId, InputStream inputStream, List<OrcType> types) throws IOException {
        CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)inputStream);
        DwrfProto.StripeEncryptionGroup stripeEncryptionGroup = DwrfProto.StripeEncryptionGroup.parseFrom((CodedInputStream)codedInputStream);
        List<Stream> encryptedStreams = DwrfMetadataReader.toStream(orcDataSourceId, stripeEncryptionGroup.getStreamsList());
        return new StripeEncryptionGroup(encryptedStreams, DwrfMetadataReader.toColumnEncoding(types, (List<DwrfProto.ColumnEncoding>)stripeEncryptionGroup.getEncodingList()));
    }
}

