/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.array.Arrays;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamDwrf;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.facebook.presto.orc.writer.LongColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class LongDictionaryColumnWriter
extends DictionaryColumnWriter {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(LongDictionaryColumnWriter.class).instanceSize();
    private static final int NULL_INDEX = -1;
    private final LongOutputStream dictionaryDataStream;
    private final int typeSize;
    private LongDictionary dictionary;
    private IntegerStatisticsBuilder statisticsBuilder;
    private ColumnEncoding columnEncoding;
    private LongColumnWriter directColumnWriter;
    private long[] directValues;
    private boolean[] directNulls;

    public LongDictionaryColumnWriter(int column, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, MetadataWriter metadataWriter) {
        super(column, type, columnWriterOptions, dwrfEncryptor, orcEncoding, metadataWriter);
        Preconditions.checkArgument((orcEncoding == OrcEncoding.DWRF ? 1 : 0) != 0, (Object)"Long dictionary encoding is only supported in DWRF");
        Preconditions.checkArgument((boolean)(type instanceof FixedWidthType), (Object)"Not a fixed width type");
        this.dictionaryDataStream = new LongOutputStreamDwrf(columnWriterOptions, dwrfEncryptor, true, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionary = new LongDictionary(10000);
        this.typeSize = ((FixedWidthType)type).getFixedSize();
        this.statisticsBuilder = new IntegerStatisticsBuilder();
    }

    @Override
    public int getDictionaryEntries() {
        return this.dictionary.size();
    }

    @Override
    public int getDictionaryBytes() {
        return this.dictionary.size() * this.typeSize;
    }

    @Override
    protected ColumnWriter createDirectColumnWriter() {
        if (this.directColumnWriter == null) {
            this.directColumnWriter = new LongColumnWriter(this.column, this.type, this.columnWriterOptions, this.dwrfEncryptor, this.orcEncoding, IntegerStatisticsBuilder::new, this.metadataWriter);
        }
        return this.directColumnWriter;
    }

    @Override
    protected ColumnWriter getDirectColumnWriter() {
        Preconditions.checkState((this.directColumnWriter != null ? 1 : 0) != 0);
        return this.directColumnWriter;
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, int[] dictionaryIndexes, int maxDirectBytes) {
        if (dictionaryIndexCount > 0) {
            this.directValues = Arrays.ensureCapacity(this.directValues, dictionaryIndexCount);
            this.directNulls = Arrays.ensureCapacity(this.directNulls, dictionaryIndexCount);
            for (int i = 0; i < dictionaryIndexCount; ++i) {
                if (dictionaryIndexes[i] != -1) {
                    this.directValues[i] = this.dictionary.getValue(dictionaryIndexes[i]);
                    this.directNulls[i] = false;
                    continue;
                }
                this.directNulls[i] = true;
            }
            LongArrayBlock longArrayBlock = new LongArrayBlock(dictionaryIndexCount, Optional.of(this.directNulls), this.directValues);
            this.directColumnWriter.writeBlock((Block)longArrayBlock);
        }
        return this.directColumnWriter.getBufferedBytes() <= (long)maxDirectBytes;
    }

    @Override
    protected ColumnEncoding getDictionaryColumnEncoding() {
        Preconditions.checkState((this.columnEncoding != null ? 1 : 0) != 0);
        return this.columnEncoding;
    }

    @Override
    protected DictionaryColumnWriter.BlockStatistics addBlockToDictionary(Block block, int rowGroupValueCount, int[] rowGroupIndexes) {
        int nonNullValueCount = 0;
        long rawBytes = 0L;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int index;
            if (block.isNull(position)) {
                index = -1;
            } else {
                long value = this.type.getLong(block, position);
                index = this.dictionary.addIfNotExists(value);
                this.statisticsBuilder.addValue(value);
                rawBytes += (long)this.typeSize;
                ++nonNullValueCount;
            }
            rowGroupIndexes[rowGroupValueCount] = index;
            ++rowGroupValueCount;
        }
        long rawBytesIncludingNulls = rawBytes + (long)(block.getPositionCount() - nonNullValueCount) * 1L;
        return new DictionaryColumnWriter.BlockStatistics(nonNullValueCount, rawBytes, rawBytesIncludingNulls);
    }

    @Override
    protected long getRetainedDictionaryBytes() {
        return INSTANCE_SIZE + this.dictionary.getRetainedBytes() + this.dictionaryDataStream.getRetainedBytes() + SizeOf.sizeOf((long[])this.directValues) + SizeOf.sizeOf((boolean[])this.directNulls) + (this.directColumnWriter == null ? 0L : this.directColumnWriter.getRetainedBytes());
    }

    @Override
    protected Optional<int[]> writeDictionary() {
        long[] elements = this.dictionary.elements();
        for (int i = 0; i < this.dictionary.size(); ++i) {
            this.dictionaryDataStream.writeLong(elements[i]);
        }
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DICTIONARY, this.dictionary.size());
        return Optional.empty();
    }

    @Override
    protected void writePresentAndDataStreams(int rowGroupValueCount, int[] rowGroupIndexes, Optional<int[]> originalDictionaryToSortedIndex, PresentOutputStream presentStream, LongOutputStream dataStream) {
        int position;
        Preconditions.checkArgument((!originalDictionaryToSortedIndex.isPresent() ? 1 : 0) != 0, (Object)"Unsupported originalDictionaryToSortedIndex");
        for (position = 0; position < rowGroupValueCount; ++position) {
            presentStream.writeBoolean(rowGroupIndexes[position] != -1);
        }
        for (position = 0; position < rowGroupValueCount; ++position) {
            int index = rowGroupIndexes[position];
            if (index == -1) continue;
            dataStream.writeLong(index);
        }
    }

    @Override
    protected List<StreamDataOutput> getDictionaryStreams(int column) {
        return ImmutableList.of((Object)this.dictionaryDataStream.getStreamDataOutput(column));
    }

    @Override
    protected ColumnStatistics createColumnStatistics() {
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.statisticsBuilder = new IntegerStatisticsBuilder();
        return statistics;
    }

    @Override
    protected void closeDictionary() {
        this.dictionary = null;
        this.dictionaryDataStream.close();
    }

    @Override
    protected void resetDictionary() {
        this.columnEncoding = null;
        this.dictionary = new LongDictionary(10000);
        this.dictionaryDataStream.reset();
        this.statisticsBuilder = new IntegerStatisticsBuilder();
        this.directValues = null;
        this.directNulls = null;
    }

    private static class LongDictionary {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongDictionary.class).instanceSize() + ClassLayout.parseClass(Long2IntMapWithByteSize.class).instanceSize() + ClassLayout.parseClass(LongArrayList.class).instanceSize();
        private static final int UNUSED_VALUE = -1;
        private final Long2IntMapWithByteSize dictionary;
        private final LongArrayList elements;

        public LongDictionary(int expectedEntries) {
            this.dictionary = new Long2IntMapWithByteSize(expectedEntries, -1);
            this.elements = new LongArrayList(expectedEntries);
        }

        public long getRetainedBytes() {
            return (long)INSTANCE_SIZE + this.dictionary.getRetainedBytes() + SizeOf.sizeOf((long[])this.elements.elements());
        }

        public int addIfNotExists(long value) {
            int newPosition = this.dictionary.size();
            int existingPosition = this.dictionary.putIfAbsent(value, newPosition);
            if (existingPosition == -1) {
                this.elements.add(value);
                return newPosition;
            }
            return existingPosition;
        }

        public int size() {
            Preconditions.checkState((this.elements.size() == this.dictionary.size() ? 1 : 0) != 0, (Object)"size mismatch");
            return this.elements.size();
        }

        public long[] elements() {
            return this.elements.elements();
        }

        public long getValue(int index) {
            return this.elements.getLong(index);
        }
    }

    private static class Long2IntMapWithByteSize
    extends Long2IntOpenHashMap {
        public Long2IntMapWithByteSize(int expectedEntries, int unusedValue) {
            super(expectedEntries);
            this.defaultReturnValue(unusedValue);
        }

        public long getRetainedBytes() {
            return SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value);
        }
    }
}

