/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.LongValueStatisticsBuilder;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamDwrf;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

public class LongColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongColumnWriter.class).instanceSize();
    private final int column;
    private final Type type;
    private final long typeSize;
    private final boolean compressed;
    private final ColumnEncoding columnEncoding;
    private final LongOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private final CompressedMetadataWriter metadataWriter;
    private long columnStatisticsRetainedSizeInBytes;
    private final Supplier<LongValueStatisticsBuilder> statisticsBuilderSupplier;
    private LongValueStatisticsBuilder statisticsBuilder;
    private boolean closed;

    public LongColumnWriter(int column, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, Supplier<LongValueStatisticsBuilder> statisticsBuilderSupplier, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        Preconditions.checkArgument((boolean)(type instanceof FixedWidthType), (Object)"Type is not instance of FixedWidthType");
        this.column = column;
        this.type = Objects.requireNonNull(type, "type is null");
        this.typeSize = ((FixedWidthType)type).getFixedSize();
        boolean bl = this.compressed = columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        if (orcEncoding == OrcEncoding.DWRF) {
            this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
            this.dataStream = new LongOutputStreamDwrf(columnWriterOptions, dwrfEncryptor, true, Stream.StreamKind.DATA);
        } else {
            this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
            this.dataStream = new LongOutputStreamV2(columnWriterOptions, true, Stream.StreamKind.DATA);
        }
        this.presentStream = new PresentOutputStream(columnWriterOptions, dwrfEncryptor);
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
        this.statisticsBuilderSupplier = Objects.requireNonNull(statisticsBuilderSupplier, "statisticsBuilderSupplier is null");
        this.statisticsBuilder = statisticsBuilderSupplier.get();
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
    }

    @Override
    public long writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        int nonNullValueCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            long value = this.type.getLong(block, position);
            this.dataStream.writeLong(value);
            this.statisticsBuilder.addValue(value);
            ++nonNullValueCount;
        }
        return (long)nonNullValueCount * this.typeSize + (long)(block.getPositionCount() - nonNullValueCount) * 1L;
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.rowGroupColumnStatistics.add(statistics);
        this.columnStatisticsRetainedSizeInBytes += statistics.getRetainedSizeInBytes();
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.dataStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            LongStreamCheckpoint dataCheckpoint = (LongStreamCheckpoint)dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = LongColumnWriter.createLongColumnPositionList(this.compressed, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = this.metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.column, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    private static List<Integer> createLongColumnPositionList(boolean compressed, LongStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.column));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.dataStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
    }
}

