/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.TupleDomainFilterUtils;
import com.facebook.presto.orc.array.Arrays;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class MapDirectSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapDirectSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final boolean legacyMapSubscript;
    private final boolean nullsAllowed;
    private final boolean nonNullsAllowed;
    private final boolean outputRequired;
    @Nullable
    private final MapType outputType;
    private final SelectiveStreamReader keyReader;
    private final SelectiveStreamReader valueReader;
    private final OrcLocalMemoryContext systemMemoryContext;
    private int readOffset;
    private int nestedReadOffset;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;
    @Nullable
    private int[] offsets;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private int[] nestedLengths;
    private int[] nestedOffsets;
    private int[] nestedPositions;
    private int[] nestedOutputPositions;
    private int nestedOutputPositionCount;
    private boolean valuesInUse;

    public MapDirectSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> requiredSubfields, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, boolean legacyMapSubscript, OrcAggregatedMemoryContext systemMemoryContext) {
        Preconditions.checkArgument((boolean)filters.keySet().stream().map(Subfield::getPath).allMatch(List::isEmpty), (Object)"filters on nested columns are not supported yet");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.legacyMapSubscript = legacyMapSubscript;
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null").newOrcLocalMemoryContext(MapDirectSelectiveStreamReader.class.getSimpleName());
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.map(MapType.class::cast).orElse(null);
        TupleDomainFilter filter = MapDirectSelectiveStreamReader.getTopLevelFilter(filters).orElse(null);
        this.nullsAllowed = filter == null || filter.testNull();
        this.nonNullsAllowed = filter == null || filter.testNonNull();
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        Optional<Type> keyOutputType = outputType.map(MapType.class::cast).map(MapType::getKeyType);
        Optional<Type> valueOutputType = outputType.map(MapType.class::cast).map(MapType::getValueType);
        if (this.outputRequired) {
            Map keyFilter = (Map)MapDirectSelectiveStreamReader.makeKeyFilter(nestedStreams.get(0).getOrcTypeKind(), requiredSubfields, options.mapNullKeysEnabled()).map(x -> ImmutableMap.of((Object)new Subfield("c"), (Object)x)).orElseGet(ImmutableMap::of);
            Object elementRequiredSubfields = ImmutableList.of();
            if (requiredSubfields.stream().map(Subfield::getPath).allMatch(path -> path.size() > 1)) {
                elementRequiredSubfields = (List)requiredSubfields.stream().map(subfield -> subfield.tail(subfield.getRootName())).distinct().collect(ImmutableList.toImmutableList());
            }
            this.keyReader = SelectiveStreamReaders.createStreamReader(nestedStreams.get(0), keyFilter, keyOutputType, (List<Subfield>)ImmutableList.of(), hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext.newOrcAggregatedMemoryContext());
            this.valueReader = SelectiveStreamReaders.createStreamReader(nestedStreams.get(1), (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), valueOutputType, (List<Subfield>)elementRequiredSubfields, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext.newOrcAggregatedMemoryContext());
        } else {
            this.keyReader = null;
            this.valueReader = null;
        }
    }

    private static Optional<TupleDomainFilter> makeKeyFilter(OrcType.OrcTypeKind orcType, List<Subfield> requiredSubfields, boolean mapNullKeysEnabled) {
        Optional<TupleDomainFilter> defaultFilter;
        Optional<Object> optional = defaultFilter = mapNullKeysEnabled ? Optional.empty() : Optional.of(TupleDomainFilter.IS_NOT_NULL);
        if (requiredSubfields.isEmpty()) {
            return defaultFilter;
        }
        if (requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).anyMatch(Subfield.AllSubscripts.class::isInstance)) {
            return defaultFilter;
        }
        switch (orcType) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                long[] requiredIndices = requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.LongSubscript.class::cast).mapToLong(Subfield.LongSubscript::getIndex).distinct().toArray();
                if (requiredIndices.length == 0) {
                    return defaultFilter;
                }
                if (requiredIndices.length == 1) {
                    return Optional.of(TupleDomainFilter.BigintRange.of(requiredIndices[0], requiredIndices[0], mapNullKeysEnabled));
                }
                return Optional.of(TupleDomainFilterUtils.toBigintValues(requiredIndices, mapNullKeysEnabled));
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                byte[][] requiredIndices = (byte[][])requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.StringSubscript.class::cast).map(Subfield.StringSubscript::getIndex).map(String::getBytes).toArray(x$0 -> new byte[x$0][]);
                if (requiredIndices.length == 0) {
                    return defaultFilter;
                }
                if (requiredIndices.length == 1) {
                    return Optional.of(TupleDomainFilter.BytesRange.of(requiredIndices[0], false, requiredIndices[0], false, mapNullKeysEnabled));
                }
                return Optional.of(TupleDomainFilter.BytesValues.of(requiredIndices, mapNullKeysEnabled));
            }
        }
        return defaultFilter;
    }

    private static Optional<TupleDomainFilter> getTopLevelFilter(Map<Subfield, TupleDomainFilter> filters) {
        Map topLevelFilters = Maps.filterEntries(filters, entry -> ((Subfield)entry.getKey()).getPath().isEmpty());
        if (topLevelFilters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((topLevelFilters.size() == 1 ? 1 : 0) != 0, (Object)"MAP column may have at most one top-level range filter");
        TupleDomainFilter filter = (TupleDomainFilter)Iterables.getOnlyElement(topLevelFilters.values());
        Preconditions.checkArgument((filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL ? 1 : 0) != 0, (Object)"Top-level range filter on MAP column must be IS NULL or IS NOT NULL");
        return Optional.of(filter);
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.offsets = Arrays.ensureCapacity(this.offsets, positionCount + 1);
        this.offsets[0] = 0;
        this.nestedLengths = Arrays.ensureCapacity(this.nestedLengths, positionCount);
        this.nestedOffsets = Arrays.ensureCapacity(this.nestedOffsets, positionCount + 1);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.lengthStream == null) {
            this.readAllNulls(positions, positionCount);
        } else if (this.presentStream == null) {
            this.readNoNulls(offset, positions, positionCount);
        } else {
            this.readWithNulls(offset, positions, positionCount);
        }
        return this.outputPositionCount;
    }

    private int readAllNulls(int[] positions, int positionCount) {
        this.outputPositionCount = this.nullsAllowed ? positionCount : 0;
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private void readNoNulls(int offset, int[] positions, int positionCount) throws IOException {
        if (!this.nonNullsAllowed) {
            this.outputPositionCount = 0;
            return;
        }
        if (this.readOffset < offset) {
            this.nestedReadOffset = (int)((long)this.nestedReadOffset + this.lengthStream.sum(offset - this.readOffset));
        }
        int streamPosition = 0;
        int nestedOffset = 0;
        int nestedPositionCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                nestedOffset = (int)((long)nestedOffset + this.lengthStream.sum(position - streamPosition));
                streamPosition = position;
            }
            ++streamPosition;
            int length = Math.toIntExact(this.lengthStream.next());
            this.offsets[i + 1] = this.offsets[i] + length;
            this.nestedLengths[i] = length;
            this.nestedOffsets[i] = nestedOffset;
            nestedOffset += length;
            nestedPositionCount += length;
        }
        this.outputPositionCount = positionCount;
        this.readOffset = offset + streamPosition;
        if (this.outputRequired) {
            this.nestedOffsets[positionCount] = nestedOffset;
            this.populateNestedPositions(positionCount, nestedPositionCount);
            this.readKeyValueStreams(nestedPositionCount);
        }
        this.nestedReadOffset += nestedOffset;
    }

    private void readWithNulls(int offset, int[] positions, int positionCount) throws IOException {
        if (this.readOffset < offset) {
            int dataToSkip = this.presentStream.countBitsSet(offset - this.readOffset);
            this.nestedReadOffset = (int)((long)this.nestedReadOffset + this.lengthStream.sum(dataToSkip));
        }
        if (this.outputRequired) {
            this.nulls = Arrays.ensureCapacity(this.nulls, positionCount);
        }
        this.outputPositionCount = 0;
        int streamPosition = 0;
        int nonNullPositionCount = 0;
        int nestedOffset = 0;
        int nestedPositionCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                int dataToSkip = this.presentStream.countBitsSet(position - streamPosition);
                nestedOffset = (int)((long)nestedOffset + this.lengthStream.sum(dataToSkip));
                streamPosition = position;
            }
            ++streamPosition;
            if (this.presentStream.nextBit()) {
                int length = Math.toIntExact(this.lengthStream.next());
                if (this.nonNullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = false;
                        this.offsets[this.outputPositionCount + 1] = this.offsets[this.outputPositionCount] + length;
                        this.nestedLengths[nonNullPositionCount] = length;
                        this.nestedOffsets[nonNullPositionCount] = nestedOffset;
                        ++nonNullPositionCount;
                        nestedPositionCount += length;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
                nestedOffset += length;
                continue;
            }
            if (!this.nullsAllowed) continue;
            if (this.outputRequired) {
                this.nulls[this.outputPositionCount] = true;
                this.offsets[this.outputPositionCount + 1] = this.offsets[this.outputPositionCount];
            }
            this.outputPositions[this.outputPositionCount] = position;
            ++this.outputPositionCount;
        }
        if (nonNullPositionCount == 0) {
            this.allNulls = true;
        } else if (this.outputRequired) {
            this.nestedOffsets[nonNullPositionCount] = nestedOffset;
            this.populateNestedPositions(nonNullPositionCount, nestedPositionCount);
            this.readKeyValueStreams(nestedPositionCount);
        }
        this.readOffset = offset + streamPosition;
        this.nestedReadOffset += nestedOffset;
    }

    private void populateNestedPositions(int positionCount, int nestedPositionCount) {
        this.nestedPositions = Arrays.ensureCapacity(this.nestedPositions, nestedPositionCount);
        int index = 0;
        for (int i = 0; i < positionCount; ++i) {
            for (int j = 0; j < this.nestedLengths[i]; ++j) {
                this.nestedPositions[index++] = this.nestedOffsets[i] + j;
            }
        }
    }

    private void readKeyValueStreams(int positionCount) throws IOException {
        if (positionCount == 0) {
            this.nestedOutputPositionCount = 0;
            return;
        }
        int readCount = this.keyReader.read(this.nestedReadOffset, this.nestedPositions, positionCount);
        int[] readPositions = this.keyReader.getReadPositions();
        if (readCount == 0) {
            this.nestedOutputPositionCount = 0;
            for (int i = 0; i <= this.outputPositionCount; ++i) {
                this.offsets[i] = 0;
            }
            return;
        }
        if (readCount < positionCount) {
            int positionIndex = 0;
            int nextPosition = readPositions[positionIndex];
            int offset = 0;
            int previousOffset = 0;
            for (int i = 0; i < this.outputPositionCount; ++i) {
                int j;
                int length = 0;
                for (j = previousOffset; j < this.offsets[i + 1]; ++j) {
                    if (this.nestedPositions[j] != nextPosition) continue;
                    ++length;
                    if (++positionIndex >= readCount) break;
                    nextPosition = readPositions[positionIndex];
                }
                previousOffset = this.offsets[i + 1];
                this.offsets[i + 1] = offset += length;
                if (positionIndex < readCount) continue;
                for (j = i + 1; j < this.outputPositionCount; ++j) {
                    this.offsets[j + 1] = offset;
                }
                break;
            }
        }
        int valueReadCount = this.valueReader.read(this.nestedReadOffset, readPositions, readCount);
        assert (valueReadCount == readCount);
        this.nestedOutputPositions = Arrays.ensureCapacity(this.nestedOutputPositions, readCount);
        System.arraycopy(readPositions, 0, this.nestedOutputPositions, 0, readCount);
        this.nestedOutputPositionCount = readCount;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        Block valueBlock;
        Block keyBlock;
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return MapDirectSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (this.outputPositionCount == positionCount) {
            Block valueBlock2;
            Block keyBlock2;
            if (this.nestedOutputPositionCount == 0) {
                keyBlock2 = MapDirectSelectiveStreamReader.createEmptyBlock(this.outputType.getKeyType());
                valueBlock2 = MapDirectSelectiveStreamReader.createEmptyBlock(this.outputType.getValueType());
            } else {
                keyBlock2 = this.keyReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
                valueBlock2 = this.valueReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
            }
            Block block = this.outputType.createBlockFromKeyValue(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.offsets, keyBlock2, valueBlock2);
            this.nulls = null;
            this.offsets = null;
            return block;
        }
        int[] offsetsCopy = new int[positionCount + 1];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedSkipped = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                nestedSkipped += this.offsets[i + 1] - this.offsets[i];
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            offsetsCopy[positionIndex + 1] = this.offsets[i + 1] - nestedSkipped;
            for (int j = offsetsCopy[positionIndex]; j < offsetsCopy[positionIndex + 1]; ++j) {
                this.nestedOutputPositions[this.nestedOutputPositionCount] = this.nestedOutputPositions[this.nestedOutputPositionCount + nestedSkipped];
                ++this.nestedOutputPositionCount;
            }
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        if (this.nestedOutputPositionCount == 0) {
            keyBlock = MapDirectSelectiveStreamReader.createEmptyBlock(this.outputType.getKeyType());
            valueBlock = MapDirectSelectiveStreamReader.createEmptyBlock(this.outputType.getValueType());
        } else {
            keyBlock = this.keyReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
            valueBlock = this.valueReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
        }
        return this.outputType.createBlockFromKeyValue(positionCount, Optional.ofNullable((boolean[])(includeNulls ? nullsCopy : null)), offsetsCopy, keyBlock, valueBlock);
    }

    private static RunLengthEncodedBlock createNullBlock(Type type, int positionCount) {
        return new RunLengthEncodedBlock(type.createBlockBuilder(null, 1).appendNull().build(), positionCount);
    }

    private static Block createEmptyBlock(Type type) {
        return type.createBlockBuilder(null, 0).build();
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)MapDirectSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount), new BlockLease[0]);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        if (this.nestedOutputPositionCount == 0) {
            return this.newLease(this.outputType.createBlockFromKeyValue(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.offsets, MapDirectSelectiveStreamReader.createEmptyBlock(this.outputType.getKeyType()), MapDirectSelectiveStreamReader.createEmptyBlock(this.outputType.getValueType())), new BlockLease[0]);
        }
        BlockLease keyBlockLease = this.keyReader.getBlockView(this.nestedOutputPositions, this.nestedOutputPositionCount);
        BlockLease valueBlockLease = this.valueReader.getBlockView(this.nestedOutputPositions, this.nestedOutputPositionCount);
        return this.newLease(this.outputType.createBlockFromKeyValue(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.offsets, (Block)keyBlockLease.get(), (Block)valueBlockLease.get()), keyBlockLease, valueBlockLease);
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedSkipped = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                nestedSkipped += this.offsets[i + 1] - this.offsets[i];
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            this.offsets[positionIndex + 1] = this.offsets[i + 1] - nestedSkipped;
            for (int j = this.offsets[positionIndex]; j < this.offsets[positionIndex + 1]; ++j) {
                this.nestedOutputPositions[this.nestedOutputPositionCount] = this.nestedOutputPositions[this.nestedOutputPositionCount + nestedSkipped];
                ++this.nestedOutputPositionCount;
            }
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    private BlockLease newLease(Block block, BlockLease ... fieldBlockLeases) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            for (BlockLease lease : fieldBlockLeases) {
                lease.close();
            }
            this.valuesInUse = false;
        }});
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        if (this.keyReader != null) {
            this.keyReader.close();
        }
        if (this.valueReader != null) {
            this.valueReader.close();
        }
        this.nestedOffsets = null;
        this.offsets = null;
        this.nulls = null;
        this.outputPositions = null;
        this.nestedLengths = null;
        this.nestedPositions = null;
        this.nestedOutputPositions = null;
        this.lengthStream = null;
        this.lengthStreamSource = null;
        this.presentStream = null;
        this.lengthStreamSource = null;
        this.systemMemoryContext.close();
    }

    @Override
    public void startStripe(Stripe stripe) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        if (this.outputRequired) {
            this.keyReader.startStripe(stripe);
            this.valueReader.startStripe(stripe);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        if (this.outputRequired) {
            this.keyReader.startRowGroup(dataStreamSources);
            this.valueReader.startRowGroup(dataStreamSources);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.nestedLengths) + SizeOf.sizeOf((int[])this.nestedOffsets) + SizeOf.sizeOf((int[])this.nestedPositions) + SizeOf.sizeOf((int[])this.nestedOutputPositions) + (this.keyReader != null ? this.keyReader.getRetainedSizeInBytes() : 0L) + (this.valueReader != null ? this.valueReader.getRetainedSizeInBytes() : 0L);
    }
}

