/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class ByteBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ByteBatchStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteInputStream.class);
    @Nullable
    private ByteInputStream dataStream;
    private boolean rowGroupOpen;
    private byte[] nonNullValueTemp = new byte[0];
    private final OrcLocalMemoryContext systemMemoryContext;

    public ByteBatchStreamReader(Type type, StreamDescriptor streamDescriptor, OrcLocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, TinyintType.class::isInstance);
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)TinyintType.TINYINT, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)TinyintType.TINYINT, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readNonNullBlock() throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        byte[] values = this.dataStream.next(this.nextBatchSize);
        return new ByteArrayBlock(this.nextBatchSize, Optional.empty(), values);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.nonNullValueTemp.length < minNonNullValueSize) {
            this.nonNullValueTemp = new byte[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((byte[])this.nonNullValueTemp));
        }
        this.dataStream.next(this.nonNullValueTemp, nonNullCount);
        byte[] result = ReaderUtils.unpackByteNulls(this.nonNullValueTemp, isNull);
        return new ByteArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(Stripe stripe) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.nonNullValueTemp = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

