/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.BloomFilter;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.primitives.Longs;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class HiveBloomFilter
extends BloomFilter
implements StatisticsHasher.Hashable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HiveBloomFilter.class).instanceSize() + ClassLayout.parseClass(BloomFilter.BitSet.class).instanceSize();

    public HiveBloomFilter(List<Long> bits, int numBits, int numHashFunctions) {
        this.bitSet = new BloomFilter.BitSet(Longs.toArray(bits));
        this.numBits = numBits;
        this.numHashFunctions = numHashFunctions;
    }

    public HiveBloomFilter(BloomFilter bloomFilter) {
        this.bitSet = new BloomFilter.BitSet((long[])bloomFilter.getBitSet().clone());
        this.numBits = bloomFilter.getBitSize();
        this.numHashFunctions = bloomFilter.getNumHashFunctions();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.bitSet.getData());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBloomFilter that = (HiveBloomFilter)o;
        return Objects.equals(this.numBits, that.numBits) && Objects.equals(this.numHashFunctions, that.numHashFunctions) && Arrays.equals(this.bitSet.getData(), that.bitSet.getData());
    }

    public int hashCode() {
        return Objects.hash(this.numBits, this.numHashFunctions, this.bitSet.getData());
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putInt(this.numBits).putInt(this.numHashFunctions).putLongs(this.bitSet.getData());
    }
}

