/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.DwrfEncryption;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class Footer {
    private final long numberOfRows;
    private final int rowsInRowGroup;
    private final OptionalLong rawSize;
    private final List<StripeInformation> stripes;
    private final List<OrcType> types;
    private final List<ColumnStatistics> fileStats;
    private final Map<String, Slice> userMetadata;
    private final Optional<DwrfEncryption> encryption;
    private final Optional<List<Integer>> dwrfStripeCacheOffsets;

    public Footer(long numberOfRows, int rowsInRowGroup, OptionalLong rawSize, List<StripeInformation> stripes, List<OrcType> types, List<ColumnStatistics> fileStats, Map<String, Slice> userMetadata, Optional<DwrfEncryption> encryption, Optional<List<Integer>> dwrfStripeCacheOffsets) {
        this.numberOfRows = numberOfRows;
        this.rowsInRowGroup = rowsInRowGroup;
        this.rawSize = Objects.requireNonNull(rawSize, "rawSize is null");
        this.stripes = ImmutableList.copyOf((Collection)Objects.requireNonNull(stripes, "stripes is null"));
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.fileStats = ImmutableList.copyOf((Collection)Objects.requireNonNull(fileStats, "columnStatistics is null"));
        Objects.requireNonNull(userMetadata, "userMetadata is null");
        this.userMetadata = ImmutableMap.copyOf((Map)Maps.transformValues(userMetadata, Slices::copyOf));
        this.encryption = Objects.requireNonNull(encryption, "encryption is null");
        this.dwrfStripeCacheOffsets = Objects.requireNonNull(dwrfStripeCacheOffsets, "dwrfStripeCacheOffsets is null").map(ImmutableList::copyOf);
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getRowsInRowGroup() {
        return this.rowsInRowGroup;
    }

    public OptionalLong getRawSize() {
        return this.rawSize;
    }

    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    public List<OrcType> getTypes() {
        return this.types;
    }

    public List<ColumnStatistics> getFileStats() {
        return this.fileStats;
    }

    public Map<String, Slice> getUserMetadata() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.userMetadata, Slices::copyOf));
    }

    public Optional<DwrfEncryption> getEncryption() {
        return this.encryption;
    }

    public Optional<List<Integer>> getDwrfStripeCacheOffsets() {
        return this.dwrfStripeCacheOffsets;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRows", this.numberOfRows).add("rowsInRowGroup", this.rowsInRowGroup).add("stripes", this.stripes).add("types", this.types).add("columnStatistics", this.fileStats).add("userMetadata", this.userMetadata.keySet()).add("dwrfStripeCacheOffsets", this.dwrfStripeCacheOffsets).toString();
    }
}

