/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.common.io.DataOutput;
import com.facebook.presto.orc.metadata.DwrfStripeCacheData;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DwrfStripeCacheWriter {
    private final DwrfStripeCacheMode mode;
    private final DynamicSliceOutput cache;
    private final long maxSize;
    private final List<Integer> offsets = new ArrayList<Integer>();
    private int size;
    private boolean full;

    public DwrfStripeCacheWriter(DwrfStripeCacheMode mode, DataSize maxSize) {
        this.maxSize = Math.toIntExact(Objects.requireNonNull(maxSize, "maxSize is null").toBytes());
        this.mode = Objects.requireNonNull(mode, "mode is null");
        this.cache = new DynamicSliceOutput(64);
        if (mode == DwrfStripeCacheMode.NONE) {
            this.full = true;
        }
    }

    public void addIndexStreams(List<DataOutput> indexStreams, long indexSize) {
        if (this.full || !this.mode.hasIndex()) {
            return;
        }
        if ((long)this.size + indexSize > this.maxSize) {
            this.full = true;
            return;
        }
        indexStreams.forEach(indexStream -> indexStream.writeData((SliceOutput)this.cache));
        this.incrementSize(indexSize);
    }

    public void addStripeFooter(DataOutput stripeFooter) {
        if (this.full || !this.mode.hasFooter()) {
            return;
        }
        long stripeFooterSize = stripeFooter.size();
        if ((long)this.size + stripeFooterSize > this.maxSize) {
            this.full = true;
            return;
        }
        stripeFooter.writeData((SliceOutput)this.cache);
        this.incrementSize(stripeFooterSize);
    }

    private void incrementSize(long sizeIncrement) {
        if (this.offsets.isEmpty()) {
            this.offsets.add(0);
        }
        this.size = (int)((long)this.size + sizeIncrement);
        this.offsets.add(this.size);
    }

    public DwrfStripeCacheData getDwrfStripeCacheData() {
        return new DwrfStripeCacheData(this.cache.slice(), this.size, this.mode);
    }

    public List<Integer> getOffsets() {
        return ImmutableList.copyOf(this.offsets);
    }
}

