/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DwrfStripeCache {
    private final DwrfStripeCacheMode mode;
    private final Map<Long, Slice> indexSlices;
    private final Map<Long, Slice> footerSlices;

    public DwrfStripeCache(DwrfStripeCacheMode mode, Map<Long, Slice> indexSlices, Map<Long, Slice> footerSlices) {
        this.mode = Objects.requireNonNull(mode, "mode is null");
        this.indexSlices = Objects.requireNonNull(indexSlices, "indexSlices is null");
        this.footerSlices = Objects.requireNonNull(footerSlices, "footerSlices is null");
    }

    public Optional<Slice> getIndexStreamsSlice(StripeReader.StripeId stripeId) {
        if (this.mode.hasIndex()) {
            Slice slice = this.indexSlices.get(stripeId.getOffset());
            return Optional.ofNullable(slice);
        }
        return Optional.empty();
    }

    public Optional<Slice> getStripeFooterSlice(StripeReader.StripeId stripeId, int footerLength) {
        Slice slice;
        if (this.mode.hasFooter() && (slice = this.footerSlices.get(stripeId.getOffset())) != null) {
            Preconditions.checkState((footerLength == slice.length() ? 1 : 0) != 0, (String)"Requested footer size %s for stripeId %s does not match the cached footer slice size %s", (Object)footerLength, (Object)stripeId, (Object)slice.length());
            return Optional.of(slice);
        }
        return Optional.empty();
    }
}

