/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfStripeCacheData;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.StripeFooter;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CompressedMetadataWriter {
    private final MetadataWriter metadataWriter;
    private final OrcOutputBuffer buffer;

    public CompressedMetadataWriter(MetadataWriter metadataWriter, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor) {
        this.metadataWriter = Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        this.buffer = new OrcOutputBuffer(columnWriterOptions, dwrfEncryptor);
    }

    public List<Integer> getOrcMetadataVersion() {
        return this.metadataWriter.getOrcMetadataVersion();
    }

    public Slice writePostscript(int footerLength, int metadataLength, CompressionKind compression, int compressionBlockSize, Optional<DwrfStripeCacheData> dwrfStripeCacheData) throws IOException {
        DynamicSliceOutput output = new DynamicSliceOutput(64);
        this.metadataWriter.writePostscript((SliceOutput)output, footerLength, metadataLength, compression, compressionBlockSize, dwrfStripeCacheData);
        return output.slice();
    }

    public Slice writeDwrfStripeCache(Optional<DwrfStripeCacheData> dwrfStripeCacheData) throws IOException {
        int size = dwrfStripeCacheData.map(DwrfStripeCacheData::getDwrfStripeCacheSize).orElse(0);
        DynamicSliceOutput output = new DynamicSliceOutput(size);
        this.metadataWriter.writeDwrfStripeCache((SliceOutput)output, dwrfStripeCacheData);
        return output.slice();
    }

    public Slice writeMetadata(Metadata metadata) throws IOException {
        this.metadataWriter.writeMetadata(this.buffer, metadata);
        return this.getSliceOutput();
    }

    public Slice writeFooter(Footer footer) throws IOException {
        this.metadataWriter.writeFooter(this.buffer, footer);
        return this.getSliceOutput();
    }

    public Slice writeStripeFooter(StripeFooter footer) throws IOException {
        this.metadataWriter.writeStripeFooter(this.buffer, footer);
        return this.getSliceOutput();
    }

    public Slice writeRowIndexes(List<RowGroupIndex> rowGroupIndexes) throws IOException {
        this.metadataWriter.writeRowIndexes(this.buffer, rowGroupIndexes);
        return this.getSliceOutput();
    }

    private Slice getSliceOutput() {
        this.buffer.close();
        DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(this.buffer.getOutputDataSize()));
        this.buffer.writeDataTo((SliceOutput)output);
        Slice slice = output.slice();
        this.buffer.reset();
        return slice;
    }
}

