/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.EncryptionLibrary;
import com.google.common.base.Verify;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;

public class TestingEncryptionLibrary
implements EncryptionLibrary {
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder();
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();

    @Override
    public byte[] generateDataEncryptionKey(byte[] intermediateKeyMetadata) {
        return intermediateKeyMetadata;
    }

    @Override
    public byte[] encryptKey(byte[] keyMetadata, byte[] input, int offset, int length) {
        return this.encrypt(keyMetadata, input, offset, length);
    }

    @Override
    public byte[] encryptData(byte[] keyMetadata, byte[] input, int offset, int length) {
        return this.encrypt(keyMetadata, input, offset, length);
    }

    @Override
    public byte[] decryptKey(byte[] keyMetadata, byte[] input, int offset, int length) {
        return this.decrypt(keyMetadata, input, offset, length);
    }

    @Override
    public byte[] decryptData(byte[] keyMetadata, byte[] input, int offset, int length) {
        return this.decrypt(keyMetadata, input, offset, length);
    }

    private byte[] encrypt(byte[] keyMetadata, byte[] input, int offset, int length) {
        ByteBuffer inputBuffer = ByteBuffer.wrap(input, offset, length);
        ByteBuffer encoded = ENCODER.encode(inputBuffer);
        ByteBuffer output = ByteBuffer.allocate(keyMetadata.length + encoded.remaining());
        output.put(keyMetadata);
        output.put(encoded);
        output.flip();
        byte[] encrypted = new byte[output.remaining()];
        output.get(encrypted);
        return encrypted;
    }

    private byte[] decrypt(byte[] keyMetadata, byte[] input, int offset, int length) {
        ByteBuffer inputBuffer = ByteBuffer.wrap(input, offset, length);
        byte[] key = new byte[keyMetadata.length];
        inputBuffer.get(key);
        Verify.verify((boolean)Arrays.equals(keyMetadata, key), (String)"keys do not match", (Object[])new Object[0]);
        ByteBuffer encoded = ByteBuffer.allocate(inputBuffer.remaining());
        encoded.put(inputBuffer);
        encoded.flip();
        ByteBuffer decodedByteBuffer = DECODER.decode(encoded);
        byte[] decoded = new byte[decodedByteBuffer.remaining()];
        decodedByteBuffer.get(decoded);
        return decoded;
    }
}

