/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.metadata.CompressionKind;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.OptionalInt;

public class ColumnWriterOptions {
    private final CompressionKind compressionKind;
    private final OptionalInt compressionLevel;
    private final int compressionMaxBufferSize;
    private final DataSize stringStatisticsLimit;
    private final boolean integerDictionaryEncodingEnabled;
    private final boolean stringDictionarySortingEnabled;
    private final boolean ignoreDictionaryRowGroupSizes;

    public ColumnWriterOptions(CompressionKind compressionKind, OptionalInt compressionLevel, DataSize compressionMaxBufferSize, DataSize stringStatisticsLimit, boolean integerDictionaryEncodingEnabled, boolean stringDictionarySortingEnabled, boolean ignoreDictionaryRowGroupSizes) {
        this.compressionKind = Objects.requireNonNull(compressionKind, "compressionKind is null");
        this.compressionLevel = Objects.requireNonNull(compressionLevel, "compressionLevel is null");
        Objects.requireNonNull(compressionMaxBufferSize, "compressionMaxBufferSize is null");
        this.compressionMaxBufferSize = Math.toIntExact(compressionMaxBufferSize.toBytes());
        this.stringStatisticsLimit = Objects.requireNonNull(stringStatisticsLimit, "stringStatisticsLimit is null");
        this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
        this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
        this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OptionalInt getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getCompressionMaxBufferSize() {
        return this.compressionMaxBufferSize;
    }

    public DataSize getStringStatisticsLimit() {
        return this.stringStatisticsLimit;
    }

    public boolean isIntegerDictionaryEncodingEnabled() {
        return this.integerDictionaryEncodingEnabled;
    }

    public boolean isStringDictionarySortingEnabled() {
        return this.stringDictionarySortingEnabled;
    }

    public boolean isIgnoreDictionaryRowGroupSizes() {
        return this.ignoreDictionaryRowGroupSizes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CompressionKind compressionKind;
        private OptionalInt compressionLevel = OptionalInt.empty();
        private DataSize compressionMaxBufferSize = OrcWriterOptions.DEFAULT_MAX_COMPRESSION_BUFFER_SIZE;
        private DataSize stringStatisticsLimit = OrcWriterOptions.DEFAULT_MAX_STRING_STATISTICS_LIMIT;
        private boolean integerDictionaryEncodingEnabled;
        private boolean stringDictionarySortingEnabled = true;
        private boolean ignoreDictionaryRowGroupSizes;

        private Builder() {
        }

        public Builder setCompressionKind(CompressionKind compressionKind) {
            this.compressionKind = compressionKind;
            return this;
        }

        public Builder setCompressionLevel(OptionalInt compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder setCompressionMaxBufferSize(DataSize compressionMaxBufferSize) {
            this.compressionMaxBufferSize = compressionMaxBufferSize;
            return this;
        }

        public Builder setStringStatisticsLimit(DataSize stringStatisticsLimit) {
            this.stringStatisticsLimit = stringStatisticsLimit;
            return this;
        }

        public Builder setIntegerDictionaryEncodingEnabled(boolean integerDictionaryEncodingEnabled) {
            this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
            return this;
        }

        public Builder setStringDictionarySortingEnabled(boolean stringDictionarySortingEnabled) {
            this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
            return this;
        }

        public Builder setIgnoreDictionaryRowGroupSizes(boolean ignoreDictionaryRowGroupSizes) {
            this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
            return this;
        }

        public ColumnWriterOptions build() {
            return new ColumnWriterOptions(this.compressionKind, this.compressionLevel, this.compressionMaxBufferSize, this.stringStatisticsLimit, this.integerDictionaryEncodingEnabled, this.stringDictionarySortingEnabled, this.ignoreDictionaryRowGroupSizes);
        }
    }
}

