/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.CachingOrcDataSource;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDataSourceUtils;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcPermissionsException;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

abstract class AbstractOrcRecordReader<T extends StreamReader>
implements Closeable {
    protected final OrcAggregatedMemoryContext systemMemoryUsage;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(AbstractOrcRecordReader.class).instanceSize();
    private final OrcDataSource orcDataSource;
    private final T[] streamReaders;
    private final long totalRowCount;
    private final long splitLength;
    private final Set<Integer> presentColumns;
    private final long maxBlockBytes;
    private final Optional<EncryptionLibrary> encryptionLibrary;
    private final Map<Integer, Integer> dwrfEncryptionGroupMap;
    private final Map<Integer, Slice> intermediateKeyMetadata;
    private long currentPosition;
    private long currentStripePosition;
    private int currentBatchSize;
    private int nextBatchSize;
    private int maxBatchSize = 1024;
    private final List<StripeInformation> stripes;
    private final StripeReader stripeReader;
    private int currentStripe = -1;
    private OrcAggregatedMemoryContext currentStripeSystemMemoryContext;
    private Optional<DwrfEncryptionInfo> dwrfEncryptionInfo = Optional.empty();
    private final long fileRowCount;
    private final List<Long> stripeFilePositions;
    private long filePosition;
    private Iterator<RowGroup> rowGroups = ImmutableList.of().iterator();
    private int currentRowGroup = -1;
    private int currentGroupRowCount;
    private int nextRowInGroup;
    private final long[] maxBytesPerCell;
    private long maxCombinedBytesPerRow;
    private final Map<String, Slice> userMetadata;
    private final Optional<OrcWriteValidation> writeValidation;
    private final Optional<OrcWriteValidation.WriteChecksumBuilder> writeChecksumBuilder;
    private final Optional<OrcWriteValidation.StatisticsValidation> rowGroupStatisticsValidation;
    private final Optional<OrcWriteValidation.StatisticsValidation> stripeStatisticsValidation;
    private final Optional<OrcWriteValidation.StatisticsValidation> fileStatisticsValidation;
    private final RuntimeStats runtimeStats;

    public AbstractOrcRecordReader(Map<Integer, Type> includedColumns, Map<Integer, List<Subfield>> requiredSubfields, T[] streamReaders, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, List<ColumnStatistics> fileStats, List<StripeStatistics> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, List<OrcType> types, Optional<OrcDecompressor> decompressor, Optional<EncryptionLibrary> encryptionLibrary, Map<Integer, Integer> dwrfEncryptionGroupMap, Map<Integer, Slice> columnToIntermediateKeyMap, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Map<String, Slice> userMetadata, OrcAggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, StripeMetadataSource stripeMetadataSource, boolean cacheable, RuntimeStats runtimeStats) {
        Objects.requireNonNull(includedColumns, "includedColumns is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(fileStripes, "fileStripes is null");
        Objects.requireNonNull(stripeStats, "stripeStats is null");
        Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(decompressor, "decompressor is null");
        Objects.requireNonNull(encryptionLibrary, "encryptionLibrary is null");
        Objects.requireNonNull(dwrfEncryptionGroupMap, "dwrfEncryptionGroupMap is null");
        Objects.requireNonNull(columnToIntermediateKeyMap, "columnToIntermediateKeyMap is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(userMetadata, "userMetadata is null");
        Objects.requireNonNull(systemMemoryUsage, "systemMemoryUsage is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.writeChecksumBuilder = writeValidation.map(validation -> OrcWriteValidation.WriteChecksumBuilder.createWriteChecksumBuilder(includedColumns));
        this.rowGroupStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(includedColumns));
        this.stripeStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(includedColumns));
        this.fileStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(includedColumns));
        this.systemMemoryUsage = systemMemoryUsage;
        this.runtimeStats = Objects.requireNonNull(runtimeStats, "runtimeStats is null");
        ImmutableSet.Builder presentColumns = ImmutableSet.builder();
        OrcType root = types.get(0);
        for (int column : includedColumns.keySet()) {
            if (column < 0 || column >= root.getFieldCount()) continue;
            presentColumns.add((Object)column);
        }
        this.presentColumns = presentColumns.build();
        this.maxBlockBytes = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null").toBytes();
        Preconditions.checkArgument((rowsInRowGroup > 0 ? 1 : 0) != 0, (Object)"rowsInRowGroup must be greater than zero");
        ArrayList<StripeInfo> stripeInfos = new ArrayList<StripeInfo>();
        for (int i = 0; i < fileStripes.size(); ++i) {
            Optional<StripeStatistics> stats = Optional.empty();
            if (stripeStats.size() == fileStripes.size()) {
                stats = Optional.of(stripeStats.get(i));
            }
            stripeInfos.add(new StripeInfo(fileStripes.get(i), stats));
        }
        Collections.sort(stripeInfos, Comparator.comparingLong(info -> info.getStripe().getOffset()));
        long totalRowCount = 0L;
        long fileRowCount = 0L;
        ImmutableList.Builder stripes = ImmutableList.builder();
        ImmutableList.Builder stripeFilePositions = ImmutableList.builder();
        if (predicate.matches(numberOfRows, AbstractOrcRecordReader.getStatisticsByColumnOrdinal(root, fileStats))) {
            for (StripeInfo info2 : stripeInfos) {
                StripeInformation stripe = info2.getStripe();
                if (AbstractOrcRecordReader.splitContainsStripe(splitOffset, splitLength, stripe) && AbstractOrcRecordReader.isStripeIncluded(root, stripe, info2.getStats(), predicate)) {
                    stripes.add((Object)stripe);
                    stripeFilePositions.add((Object)fileRowCount);
                    totalRowCount += stripe.getNumberOfRows();
                }
                fileRowCount += stripe.getNumberOfRows();
            }
        }
        this.totalRowCount = totalRowCount;
        this.stripes = stripes.build();
        this.stripeFilePositions = stripeFilePositions.build();
        this.orcDataSource = orcDataSource = AbstractOrcRecordReader.wrapWithCacheIfTinyStripes(orcDataSource, this.stripes, maxMergeDistance, tinyStripeThreshold, systemMemoryUsage);
        this.splitLength = splitLength;
        this.fileRowCount = stripeInfos.stream().map(StripeInfo::getStripe).mapToLong(StripeInformation::getNumberOfRows).sum();
        this.userMetadata = ImmutableMap.copyOf((Map)Maps.transformValues(userMetadata, Slices::copyOf));
        this.currentStripeSystemMemoryContext = this.systemMemoryUsage.newOrcAggregatedMemoryContext();
        Set<Integer> includedOrcColumns = AbstractOrcRecordReader.getIncludedOrcColumns(types, this.presentColumns, Objects.requireNonNull(requiredSubfields, "requiredSubfields is null"));
        this.encryptionLibrary = encryptionLibrary;
        this.dwrfEncryptionGroupMap = ImmutableMap.copyOf(dwrfEncryptionGroupMap);
        this.intermediateKeyMetadata = AbstractOrcRecordReader.createIntermediateKeysMap(columnToIntermediateKeyMap, dwrfEncryptionGroupMap, orcDataSource.getId());
        this.checkPermissionsForEncryptedColumns(includedOrcColumns, dwrfEncryptionGroupMap, this.intermediateKeyMetadata);
        this.stripeReader = new StripeReader(orcDataSource, decompressor, types, includedOrcColumns, rowsInRowGroup, predicate, hiveWriterVersion, metadataReader, writeValidation, stripeMetadataSource, cacheable, this.dwrfEncryptionGroupMap, runtimeStats);
        this.streamReaders = (StreamReader[])Objects.requireNonNull(streamReaders, "streamReaders is null");
        for (int columnId = 0; columnId < root.getFieldCount(); ++columnId) {
            if (!includedColumns.containsKey(columnId)) continue;
            Preconditions.checkArgument((streamReaders[columnId] != null ? 1 : 0) != 0, (Object)("Missing stream reader for column " + columnId));
        }
        this.maxBytesPerCell = new long[streamReaders.length];
        OptionalInt fixedWidthRowSize = AbstractOrcRecordReader.getFixedWidthRowSize(this.presentColumns, includedColumns);
        this.nextBatchSize = fixedWidthRowSize.isPresent() ? (fixedWidthRowSize.getAsInt() == 0 ? 1024 : AbstractOrcRecordReader.adjustMaxBatchSize(1024, this.maxBlockBytes, fixedWidthRowSize.getAsInt())) : initialBatchSize;
    }

    private static Set<Integer> getIncludedOrcColumns(List<OrcType> types, Set<Integer> includedColumns, Map<Integer, List<Subfield>> requiredSubfields) {
        LinkedHashSet<Integer> includes = new LinkedHashSet<Integer>();
        OrcType root = types.get(0);
        for (int includedColumn : includedColumns) {
            List<Subfield> subfields = Optional.ofNullable(requiredSubfields.get(includedColumn)).orElse((List<Subfield>)ImmutableList.of());
            AbstractOrcRecordReader.includeOrcColumnsRecursive(types, includes, root.getFieldTypeIndex(includedColumn), subfields);
        }
        return includes;
    }

    private static void includeOrcColumnsRecursive(List<OrcType> types, Set<Integer> result, int typeId, List<Subfield> requiredSubfields) {
        result.add(typeId);
        OrcType type = types.get(typeId);
        Optional<Object> requiredFields = Optional.empty();
        if (type.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            requiredFields = AbstractOrcRecordReader.getRequiredFields(requiredSubfields);
        }
        int children = type.getFieldCount();
        for (int i = 0; i < children; ++i) {
            Object subfields = ImmutableList.of();
            if (requiredFields.isPresent()) {
                String fieldName = type.getFieldNames().get(i).toLowerCase(Locale.ENGLISH);
                if (!((Map)requiredFields.get()).containsKey(fieldName)) continue;
                subfields = (List)((Map)requiredFields.get()).get(fieldName);
            }
            AbstractOrcRecordReader.includeOrcColumnsRecursive(types, result, type.getFieldTypeIndex(i), (List<Subfield>)subfields);
        }
    }

    private static Optional<Map<String, List<Subfield>>> getRequiredFields(List<Subfield> requiredSubfields) {
        if (requiredSubfields.isEmpty()) {
            return Optional.empty();
        }
        HashMap<String, List> fields = new HashMap<String, List>();
        for (Subfield subfield : requiredSubfields) {
            List path = subfield.getPath();
            String name = ((Subfield.NestedField)path.get(0)).getName().toLowerCase(Locale.ENGLISH);
            fields.computeIfAbsent(name, k -> new ArrayList());
            if (path.size() <= 1) continue;
            ((List)fields.get(name)).add(new Subfield("c", path.subList(1, path.size())));
        }
        return Optional.of(ImmutableMap.copyOf(fields));
    }

    private static Map<Integer, Slice> createIntermediateKeysMap(Map<Integer, Slice> columnsToKeys, Map<Integer, Integer> dwrfEncryptionGroupMap, OrcDataSourceId dataSourceId) {
        HashMap<Integer, Slice> intermediateKeys = new HashMap<Integer, Slice>(dwrfEncryptionGroupMap.values().size());
        for (Map.Entry<Integer, Slice> entry : columnsToKeys.entrySet()) {
            int group;
            Slice previous;
            Slice key = entry.getValue();
            int orcColumn = entry.getKey();
            if (!dwrfEncryptionGroupMap.containsKey(orcColumn) || (previous = intermediateKeys.putIfAbsent(group = dwrfEncryptionGroupMap.get(orcColumn).intValue(), key)) == null || key.equals((Object)previous)) continue;
            throw new OrcCorruptionException(dataSourceId, "intermediate keys mapping does not match encryption groups");
        }
        return ImmutableMap.copyOf(intermediateKeys);
    }

    private void checkPermissionsForEncryptedColumns(Set<Integer> includedOrcColumns, Map<Integer, Integer> dwrfEncryptionGroupMap, Map<Integer, Slice> intermediateKeyMetadata) {
        for (Integer column : includedOrcColumns) {
            if (!dwrfEncryptionGroupMap.containsKey(column) || intermediateKeyMetadata.containsKey(dwrfEncryptionGroupMap.get(column))) continue;
            throw new OrcPermissionsException(this.orcDataSource.getId(), "No IEK provided to Decrypt column number %s", column);
        }
    }

    private static OptionalInt getFixedWidthRowSize(Set<Integer> columns, Map<Integer, Type> columnTypes) {
        int totalFixedWidth = 0;
        for (int column : columns) {
            Type type = columnTypes.get(column);
            if (type instanceof FixedWidthType) {
                totalFixedWidth += ((FixedWidthType)type).getFixedSize() + 1;
                continue;
            }
            return OptionalInt.empty();
        }
        return OptionalInt.of(totalFixedWidth);
    }

    public long getMaxCombinedBytesPerRow() {
        return this.maxCombinedBytesPerRow;
    }

    protected void updateMaxCombinedBytesPerRow(int columnIndex, Block block) {
        long bytesPerCell;
        if (block.getPositionCount() > 0 && this.maxBytesPerCell[columnIndex] < (bytesPerCell = block.getSizeInBytes() / (long)block.getPositionCount())) {
            this.maxCombinedBytesPerRow = this.maxCombinedBytesPerRow - this.maxBytesPerCell[columnIndex] + bytesPerCell;
            this.maxBytesPerCell[columnIndex] = bytesPerCell;
            this.maxBatchSize = AbstractOrcRecordReader.adjustMaxBatchSize(this.maxBatchSize, this.maxBlockBytes, this.maxCombinedBytesPerRow);
        }
    }

    protected T[] getStreamReaders() {
        return this.streamReaders;
    }

    private static boolean splitContainsStripe(long splitOffset, long splitLength, StripeInformation stripe) {
        long splitEndOffset = splitOffset + splitLength;
        return splitOffset <= stripe.getOffset() && stripe.getOffset() < splitEndOffset;
    }

    private static boolean isStripeIncluded(OrcType rootStructType, StripeInformation stripe, Optional<StripeStatistics> stripeStats, OrcPredicate predicate) {
        if (!stripeStats.isPresent()) {
            return true;
        }
        return predicate.matches(stripe.getNumberOfRows(), AbstractOrcRecordReader.getStatisticsByColumnOrdinal(rootStructType, stripeStats.get().getColumnStatistics()));
    }

    @VisibleForTesting
    static OrcDataSource wrapWithCacheIfTinyStripes(OrcDataSource dataSource, List<StripeInformation> stripes, DataSize maxMergeDistance, DataSize tinyStripeThreshold, OrcAggregatedMemoryContext systemMemoryContext) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        for (StripeInformation stripe : stripes) {
            if (stripe.getTotalLength() <= tinyStripeThreshold.toBytes()) continue;
            return dataSource;
        }
        return new CachingOrcDataSource(dataSource, LinearProbeRangeFinder.createTinyStripesRangeFinder(stripes, maxMergeDistance, tinyStripeThreshold), systemMemoryContext.newOrcLocalMemoryContext(CachingOrcDataSource.class.getSimpleName()));
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    public long getFileRowCount() {
        return this.fileRowCount;
    }

    public long getReaderPosition() {
        return this.currentPosition;
    }

    public long getReaderRowCount() {
        return this.totalRowCount;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.orcDataSource);
            for (T column : this.streamReaders) {
                if (column == null) continue;
                closer.register(() -> column.close());
            }
        }
        this.rowGroups = null;
        if (this.writeChecksumBuilder.isPresent()) {
            OrcWriteValidation.WriteChecksum actualChecksum = this.writeChecksumBuilder.get().build();
            this.validateWrite((Predicate<OrcWriteValidation>)((Predicate)validation -> validation.getChecksum().getTotalRowCount() == actualChecksum.getTotalRowCount()), "Invalid row count", new Object[0]);
            List<Long> columnHashes = actualChecksum.getColumnHashes();
            int i = 0;
            while (i < columnHashes.size()) {
                int columnIndex = i++;
                this.validateWrite((Predicate<OrcWriteValidation>)((Predicate)validation -> validation.getChecksum().getColumnHashes().get(columnIndex).equals(columnHashes.get(columnIndex))), "Invalid checksum for column %s", columnIndex);
            }
            this.validateWrite((Predicate<OrcWriteValidation>)((Predicate)validation -> validation.getChecksum().getStripeHash() == actualChecksum.getStripeHash()), "Invalid stripes checksum", new Object[0]);
        }
        if (this.fileStatisticsValidation.isPresent()) {
            List<ColumnStatistics> columnStatistics = this.fileStatisticsValidation.get().build();
            this.writeValidation.get().validateFileStatistics(this.orcDataSource.getId(), columnStatistics);
        }
    }

    public boolean isColumnPresent(int hiveColumnIndex) {
        return this.presentColumns.contains(hiveColumnIndex);
    }

    public Map<String, Slice> getUserMetadata() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.userMetadata, Slices::copyOf));
    }

    private boolean advanceToNextRowGroup() throws IOException {
        this.nextRowInGroup = 0;
        if (this.currentRowGroup >= 0 && this.rowGroupStatisticsValidation.isPresent()) {
            OrcWriteValidation.StatisticsValidation statisticsValidation = this.rowGroupStatisticsValidation.get();
            long offset = this.stripes.get(this.currentStripe).getOffset();
            this.writeValidation.get().validateRowGroupStatistics(this.orcDataSource.getId(), offset, this.currentRowGroup, statisticsValidation.build());
            statisticsValidation.reset();
        }
        while (!this.rowGroups.hasNext() && this.currentStripe < this.stripes.size()) {
            this.advanceToNextStripe();
            this.currentRowGroup = -1;
        }
        if (!this.rowGroups.hasNext()) {
            this.currentGroupRowCount = 0;
            return false;
        }
        ++this.currentRowGroup;
        RowGroup currentRowGroup = this.rowGroups.next();
        this.currentGroupRowCount = Math.toIntExact(currentRowGroup.getRowCount());
        if (currentRowGroup.getMinAverageRowBytes() > 0L) {
            this.maxBatchSize = AbstractOrcRecordReader.adjustMaxBatchSize(this.maxBatchSize, this.maxBlockBytes, currentRowGroup.getMinAverageRowBytes());
        }
        this.currentPosition = this.currentStripePosition + currentRowGroup.getRowOffset();
        this.filePosition = this.stripeFilePositions.get(this.currentStripe) + currentRowGroup.getRowOffset();
        InputStreamSources rowGroupStreamSources = currentRowGroup.getStreamSources();
        for (T column : this.streamReaders) {
            if (column == null) continue;
            column.startRowGroup(rowGroupStreamSources);
        }
        return true;
    }

    private static int adjustMaxBatchSize(int maxBatchSize, long maxBlockBytes, long averageRowBytes) {
        return Math.toIntExact(Math.min((long)maxBatchSize, Math.max(1L, maxBlockBytes / averageRowBytes)));
    }

    protected int getNextRowInGroup() {
        return this.nextRowInGroup;
    }

    protected void batchRead(int batchSize) {
        this.nextRowInGroup += batchSize;
    }

    protected int prepareNextBatch() throws IOException {
        this.filePosition += (long)this.currentBatchSize;
        this.currentPosition += (long)this.currentBatchSize;
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            this.filePosition = this.fileRowCount;
            this.currentPosition = this.totalRowCount;
            return -1;
        }
        this.currentBatchSize = Math.toIntExact(Math.min(this.nextBatchSize, this.maxBatchSize));
        this.nextBatchSize = Math.min(this.currentBatchSize * 2, 1024);
        this.currentBatchSize = Math.toIntExact(Math.min(this.currentBatchSize, this.currentGroupRowCount - this.nextRowInGroup));
        return this.currentBatchSize;
    }

    private void advanceToNextStripe() throws IOException {
        SharedBuffer sharedDecompressionBuffer;
        Stripe stripe;
        this.currentStripeSystemMemoryContext.close();
        this.currentStripeSystemMemoryContext = this.systemMemoryUsage.newOrcAggregatedMemoryContext();
        this.rowGroups = ImmutableList.of().iterator();
        if (this.currentStripe >= 0 && this.stripeStatisticsValidation.isPresent()) {
            OrcWriteValidation.StatisticsValidation statisticsValidation = this.stripeStatisticsValidation.get();
            long offset = this.stripes.get(this.currentStripe).getOffset();
            this.writeValidation.get().validateStripeStatistics(this.orcDataSource.getId(), offset, statisticsValidation.build());
            statisticsValidation.reset();
        }
        ++this.currentStripe;
        if (this.currentStripe >= this.stripes.size()) {
            return;
        }
        if (this.currentStripe > 0) {
            this.currentStripePosition += this.stripes.get(this.currentStripe - 1).getNumberOfRows();
        }
        StripeInformation stripeInformation = this.stripes.get(this.currentStripe);
        this.validateWriteStripe(stripeInformation.getNumberOfRows());
        List<byte[]> stripeDecryptionKeyMetadata = AbstractOrcRecordReader.getDecryptionKeyMetadata(this.currentStripe, this.stripes);
        if (!stripeDecryptionKeyMetadata.isEmpty() && !this.dwrfEncryptionInfo.isPresent() || this.dwrfEncryptionInfo.isPresent() && !stripeDecryptionKeyMetadata.equals(this.dwrfEncryptionInfo.get().getEncryptedKeyMetadatas())) {
            Verify.verify((boolean)this.encryptionLibrary.isPresent(), (String)"encryptionLibrary is absent", (Object[])new Object[0]);
            this.dwrfEncryptionInfo = Optional.of(DwrfEncryptionInfo.createDwrfEncryptionInfo(this.encryptionLibrary.get(), stripeDecryptionKeyMetadata, this.intermediateKeyMetadata, this.dwrfEncryptionGroupMap));
        }
        if ((stripe = this.stripeReader.readStripe(stripeInformation, this.currentStripeSystemMemoryContext, this.dwrfEncryptionInfo, sharedDecompressionBuffer = new SharedBuffer(this.currentStripeSystemMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")))) != null) {
            for (T column : this.streamReaders) {
                if (column == null) continue;
                column.startStripe(stripe);
            }
            this.rowGroups = stripe.getRowGroups().iterator();
        }
    }

    @VisibleForTesting
    public static List<byte[]> getDecryptionKeyMetadata(int currentStripe, List<StripeInformation> stripes) {
        for (int i = currentStripe; i >= 0; --i) {
            if (stripes.get(i).getKeyMetadata().isEmpty()) continue;
            return stripes.get(i).getKeyMetadata();
        }
        return ImmutableList.of();
    }

    private void validateWrite(Predicate<OrcWriteValidation> test, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (this.writeValidation.isPresent() && !test.apply((Object)this.writeValidation.get())) {
            throw new OrcCorruptionException(this.orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }

    private void validateWriteStripe(long rowCount) {
        if (this.writeChecksumBuilder.isPresent()) {
            this.writeChecksumBuilder.get().addStripe(rowCount);
        }
    }

    private static Map<Integer, ColumnStatistics> getStatisticsByColumnOrdinal(OrcType rootStructType, List<ColumnStatistics> fileStats) {
        Objects.requireNonNull(rootStructType, "rootStructType is null");
        Preconditions.checkArgument((rootStructType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT ? 1 : 0) != 0);
        Objects.requireNonNull(fileStats, "fileStats is null");
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < rootStructType.getFieldCount(); ++ordinal) {
            ColumnStatistics element;
            if (fileStats.size() <= ordinal || (element = fileStats.get(rootStructType.getFieldTypeIndex(ordinal))) == null) continue;
            statistics.put((Object)ordinal, (Object)element);
        }
        return statistics.build();
    }

    @VisibleForTesting
    long getStreamReaderRetainedSizeInBytes() {
        long totalRetainedSizeInBytes = 0L;
        for (T column : this.streamReaders) {
            if (column == null) continue;
            totalRetainedSizeInBytes += column.getRetainedSizeInBytes();
        }
        return totalRetainedSizeInBytes;
    }

    @VisibleForTesting
    long getCurrentStripeRetainedSizeInBytes() {
        return this.currentStripeSystemMemoryContext.getBytes();
    }

    protected long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getStreamReaderRetainedSizeInBytes() + this.getCurrentStripeRetainedSizeInBytes();
    }

    @VisibleForTesting
    long getSystemMemoryUsage() {
        return this.systemMemoryUsage.getBytes();
    }

    protected static StreamDescriptor createStreamDescriptor(String parentStreamName, String fieldName, int typeId, List<OrcType> types, OrcDataSource dataSource) {
        OrcType type = types.get(typeId);
        if (!fieldName.isEmpty()) {
            parentStreamName = parentStreamName + "." + fieldName;
        }
        ImmutableList.Builder nestedStreams = ImmutableList.builder();
        if (type.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            for (int i = 0; i < type.getFieldCount(); ++i) {
                nestedStreams.add((Object)AbstractOrcRecordReader.createStreamDescriptor(parentStreamName, type.getFieldName(i), type.getFieldTypeIndex(i), types, dataSource));
            }
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.LIST) {
            nestedStreams.add((Object)AbstractOrcRecordReader.createStreamDescriptor(parentStreamName, "item", type.getFieldTypeIndex(0), types, dataSource));
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.MAP) {
            nestedStreams.add((Object)AbstractOrcRecordReader.createStreamDescriptor(parentStreamName, "key", type.getFieldTypeIndex(0), types, dataSource));
            nestedStreams.add((Object)AbstractOrcRecordReader.createStreamDescriptor(parentStreamName, "value", type.getFieldTypeIndex(1), types, dataSource));
        }
        return new StreamDescriptor(parentStreamName, typeId, fieldName, type, dataSource, (List<StreamDescriptor>)nestedStreams.build());
    }

    protected boolean shouldValidateWritePageChecksum() {
        return this.writeChecksumBuilder.isPresent();
    }

    protected void validateWritePageChecksum(Page page) {
        if (this.writeChecksumBuilder.isPresent()) {
            this.writeChecksumBuilder.get().addPage(page);
            this.rowGroupStatisticsValidation.get().addPage(page);
            this.stripeStatisticsValidation.get().addPage(page);
            this.fileStatisticsValidation.get().addPage(page);
        }
    }

    @VisibleForTesting
    static class LinearProbeRangeFinder
    implements CachingOrcDataSource.RegionFinder {
        private final List<DiskRange> diskRanges;
        private int index;

        public LinearProbeRangeFinder(List<DiskRange> diskRanges) {
            this.diskRanges = diskRanges;
        }

        @Override
        public DiskRange getRangeFor(long desiredOffset) {
            while (this.index < this.diskRanges.size()) {
                DiskRange range = this.diskRanges.get(this.index);
                if (range.getEnd() > desiredOffset) {
                    Preconditions.checkArgument((range.getOffset() <= desiredOffset ? 1 : 0) != 0);
                    return range;
                }
                ++this.index;
            }
            throw new IllegalArgumentException("Invalid desiredOffset " + desiredOffset);
        }

        public static LinearProbeRangeFinder createTinyStripesRangeFinder(List<StripeInformation> stripes, DataSize maxMergeDistance, DataSize tinyStripeThreshold) {
            if (stripes.size() == 0) {
                return new LinearProbeRangeFinder((List<DiskRange>)ImmutableList.of());
            }
            List<DiskRange> scratchDiskRanges = stripes.stream().map(stripe -> new DiskRange(stripe.getOffset(), Math.toIntExact(stripe.getTotalLength()))).collect(Collectors.toList());
            List<DiskRange> diskRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(scratchDiskRanges, maxMergeDistance, tinyStripeThreshold);
            return new LinearProbeRangeFinder(diskRanges);
        }
    }

    private static class StripeInfo {
        private final StripeInformation stripe;
        private final Optional<StripeStatistics> stats;

        public StripeInfo(StripeInformation stripe, Optional<StripeStatistics> stats) {
            this.stripe = Objects.requireNonNull(stripe, "stripe is null");
            this.stats = Objects.requireNonNull(stats, "metadata is null");
        }

        public StripeInformation getStripe() {
            return this.stripe;
        }

        public Optional<StripeStatistics> getStats() {
            return this.stats;
        }
    }
}

