/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcLocalMemoryContext;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SharedBuffer {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private final OrcLocalMemoryContext bufferMemoryUsage;
    private byte[] buffer = EMPTY_BUFFER;

    public SharedBuffer(OrcLocalMemoryContext bufferMemoryUsage) {
        this.bufferMemoryUsage = Objects.requireNonNull(bufferMemoryUsage, "bufferMemoryUsage is null");
    }

    public byte[] get() {
        return this.buffer;
    }

    public void ensureCapacity(int size) {
        if (this.buffer.length < size) {
            this.buffer = new byte[size];
            this.bufferMemoryUsage.setBytes(size);
        }
    }
}

