/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.ByteArrayStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionParameters;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class ByteArrayOutputStream
implements ValueOutputStream<ByteArrayStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ByteArrayOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    private final List<ByteArrayStreamCheckpoint> checkpoints = new ArrayList<ByteArrayStreamCheckpoint>();
    private final Stream.StreamKind streamKind;
    private boolean closed;

    public ByteArrayOutputStream(CompressionParameters compressionParameters, Optional<DwrfDataEncryptor> dwrfEncryptor) {
        this(compressionParameters, dwrfEncryptor, Stream.StreamKind.DATA);
    }

    public ByteArrayOutputStream(CompressionParameters compressionParameters, Optional<DwrfDataEncryptor> dwrfEncryptor, Stream.StreamKind streamKind) {
        this.buffer = new OrcOutputBuffer(compressionParameters, dwrfEncryptor);
        this.streamKind = streamKind;
    }

    public void writeSlice(Slice value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeBytes(value);
    }

    public void writeSlice(Slice slice, int sourceIndex, int length) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeBytes(slice, sourceIndex, length);
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.close();
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new ByteArrayStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public List<ByteArrayStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(column, this.streamKind, Math.toIntExact(this.buffer.getOutputDataSize()), false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

