/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.LongDictionarySelectiveStreamReader;
import com.facebook.presto.orc.reader.LongDirectSelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class LongSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final LongDirectSelectiveStreamReader directReader;
    private final LongDictionarySelectiveStreamReader dictionaryReader;
    private SelectiveStreamReader currentReader;

    public LongSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, OrcAggregatedMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.directReader = new LongDirectSelectiveStreamReader(streamDescriptor, filter, outputType, systemMemoryContext.newOrcLocalMemoryContext(LongSelectiveStreamReader.class.getSimpleName()));
        this.dictionaryReader = new LongDictionarySelectiveStreamReader(streamDescriptor, filter, outputType, systemMemoryContext.newOrcLocalMemoryContext(LongSelectiveStreamReader.class.getSimpleName()));
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, Map<Integer, ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncoding(this.streamDescriptor.getSequence()).getColumnEncodingKind();
        switch (kind) {
            case DIRECT: 
            case DIRECT_V2: 
            case DWRF_DIRECT: {
                this.currentReader = this.directReader;
                break;
            }
            case DICTIONARY: {
                this.currentReader = this.dictionaryReader;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
            }
        }
        this.currentReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.directReader::close);
            closer.register(this.dictionaryReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.directReader.getRetainedSizeInBytes() + this.dictionaryReader.getRetainedSizeInBytes();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        return this.currentReader.read(offset, positions, positionCount);
    }

    @Override
    public int[] getReadPositions() {
        return this.currentReader.getReadPositions();
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        return this.currentReader.getBlock(positions, positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        return this.currentReader.getBlockView(positions, positionCount);
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
        this.currentReader.throwAnyError(positions, positionCount);
    }
}

