/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.DecodeTimestampOptions;

final class ApacheHiveTimestampDecoder {
    private ApacheHiveTimestampDecoder() {
    }

    public static long decodeTimestamp(long seconds, long serializedNanos, DecodeTimestampOptions options) {
        long millis = (seconds + options.getBaseSeconds()) * options.getUnitsPerSecond();
        long nanos = ApacheHiveTimestampDecoder.parseNanos(serializedNanos);
        if (nanos > 999999999L || nanos < 0L) {
            throw new IllegalArgumentException("nanos field of an encoded timestamp in ORC must be between 0 and 999999999 inclusive, got " + nanos);
        }
        if (millis < 0L && nanos != 0L) {
            millis -= options.getUnitsPerSecond();
        }
        return millis + nanos / options.getNanosPerUnit();
    }

    private static int parseNanos(long serialized) {
        int zeros = (int)serialized & 7;
        int result = (int)(serialized >>> 3);
        if (zeros != 0) {
            for (int i = 0; i <= zeros; ++i) {
                result *= 10;
            }
        }
        return result;
    }
}

