/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcDataSourceId;
import java.io.IOException;
import java.io.UncheckedIOException;

public class OrcCorruptionException
extends UncheckedIOException {
    public OrcCorruptionException(OrcDataSourceId orcDataSourceId, String message) {
        this(orcDataSourceId, "%s", message);
    }

    public OrcCorruptionException(OrcDataSourceId orcDataSourceId, String messageFormat, Object ... args) {
        super(new IOException(OrcCorruptionException.formatMessage(orcDataSourceId, messageFormat, args)));
    }

    public OrcCorruptionException(Throwable cause, OrcDataSourceId orcDataSourceId, String messageFormat, Object ... args) {
        super(OrcCorruptionException.formatMessage(orcDataSourceId, messageFormat, args), new IOException(cause));
    }

    private static String formatMessage(OrcDataSourceId orcDataSourceId, String messageFormat, Object[] args) {
        return "Malformed ORC file. " + String.format(messageFormat, args) + " [" + orcDataSourceId + "]";
    }
}

