/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.UnsupportedEncryptionLibrary;
import com.facebook.presto.orc.metadata.KeyProvider;
import java.util.Objects;

public class DwrfEncryptionProvider {
    public static final DwrfEncryptionProvider NO_ENCRYPTION = new DwrfEncryptionProvider(new UnsupportedEncryptionLibrary(), new UnsupportedEncryptionLibrary());
    private final EncryptionLibrary cryptoServiceLibrary;
    private final EncryptionLibrary unknownLibrary;

    public DwrfEncryptionProvider(EncryptionLibrary cryptoServiceLibrary, EncryptionLibrary unknownLibrary) {
        this.cryptoServiceLibrary = Objects.requireNonNull(cryptoServiceLibrary, "cryptoServiceLibrary is null");
        this.unknownLibrary = Objects.requireNonNull(unknownLibrary, "unknownLibrary is null");
    }

    public EncryptionLibrary getEncryptionLibrary(KeyProvider keyProvider) {
        switch (keyProvider) {
            case CRYPTO_SERVICE: {
                if (this.cryptoServiceLibrary instanceof UnsupportedEncryptionLibrary) {
                    throw new UnsupportedOperationException("\"crypto_service\" encryption is not configured");
                }
                return this.cryptoServiceLibrary;
            }
            case UNKNOWN: {
                if (this.unknownLibrary instanceof UnsupportedEncryptionLibrary) {
                    throw new UnsupportedOperationException("\"unknown\" encryption is not configured");
                }
                return this.unknownLibrary;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown KeyProvider: %s", new Object[]{keyProvider}));
    }
}

