/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.metadata.CompressionParameters;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.writer.BooleanColumnWriter;
import com.facebook.presto.orc.writer.ByteColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DecimalColumnWriter;
import com.facebook.presto.orc.writer.DoubleColumnWriter;
import com.facebook.presto.orc.writer.FloatColumnWriter;
import com.facebook.presto.orc.writer.ListColumnWriter;
import com.facebook.presto.orc.writer.LongColumnWriter;
import com.facebook.presto.orc.writer.MapColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.facebook.presto.orc.writer.StructColumnWriter;
import com.facebook.presto.orc.writer.TimestampColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTimeZone;

public final class ColumnWriters {
    private ColumnWriters() {
    }

    public static ColumnWriter createColumnWriter(int columnIndex, List<OrcType> orcTypes, Type type, CompressionParameters compressionParameters, OrcEncoding orcEncoding, DateTimeZone hiveStorageTimeZone, DataSize stringStatisticsLimit, DwrfEncryptionInfo dwrfEncryptors, MetadataWriter metadataWriter) {
        Objects.requireNonNull(type, "type is null");
        OrcType orcType = orcTypes.get(columnIndex);
        Optional<DwrfDataEncryptor> dwrfEncryptor = dwrfEncryptors.getEncryptorByNodeId(columnIndex);
        switch (orcType.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, metadataWriter);
            }
            case FLOAT: {
                return new FloatColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, metadataWriter);
            }
            case DOUBLE: {
                return new DoubleColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, metadataWriter);
            }
            case BYTE: {
                return new ByteColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, metadataWriter);
            }
            case DATE: {
                Preconditions.checkArgument((orcEncoding != OrcEncoding.DWRF ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
                return new LongColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, orcEncoding, DateStatisticsBuilder::new, metadataWriter);
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, orcEncoding, IntegerStatisticsBuilder::new, metadataWriter);
            }
            case DECIMAL: {
                Preconditions.checkArgument((orcEncoding != OrcEncoding.DWRF ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
                return new DecimalColumnWriter(columnIndex, type, compressionParameters, orcEncoding, metadataWriter);
            }
            case TIMESTAMP: {
                return new TimestampColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, orcEncoding, hiveStorageTimeZone, metadataWriter);
            }
            case BINARY: {
                return new SliceDirectColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, orcEncoding, BinaryStatisticsBuilder::new, metadataWriter);
            }
            case CHAR: {
                Preconditions.checkArgument((orcEncoding != OrcEncoding.DWRF ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
            }
            case VARCHAR: 
            case STRING: {
                return new SliceDictionaryColumnWriter(columnIndex, type, compressionParameters, dwrfEncryptor, orcEncoding, stringStatisticsLimit, metadataWriter);
            }
            case LIST: {
                int fieldColumnIndex = orcType.getFieldTypeIndex(0);
                Type fieldType = (Type)type.getTypeParameters().get(0);
                ColumnWriter elementWriter = ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compressionParameters, orcEncoding, hiveStorageTimeZone, stringStatisticsLimit, dwrfEncryptors, metadataWriter);
                return new ListColumnWriter(columnIndex, compressionParameters, dwrfEncryptor, orcEncoding, elementWriter, metadataWriter);
            }
            case MAP: {
                ColumnWriter keyWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(0), orcTypes, (Type)type.getTypeParameters().get(0), compressionParameters, orcEncoding, hiveStorageTimeZone, stringStatisticsLimit, dwrfEncryptors, metadataWriter);
                ColumnWriter valueWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(1), orcTypes, (Type)type.getTypeParameters().get(1), compressionParameters, orcEncoding, hiveStorageTimeZone, stringStatisticsLimit, dwrfEncryptors, metadataWriter);
                return new MapColumnWriter(columnIndex, compressionParameters, dwrfEncryptor, orcEncoding, keyWriter, valueWriter, metadataWriter);
            }
            case STRUCT: {
                ImmutableList.Builder fieldWriters = ImmutableList.builder();
                for (int fieldId = 0; fieldId < orcType.getFieldCount(); ++fieldId) {
                    int fieldColumnIndex = orcType.getFieldTypeIndex(fieldId);
                    Type fieldType = (Type)type.getTypeParameters().get(fieldId);
                    fieldWriters.add((Object)ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compressionParameters, orcEncoding, hiveStorageTimeZone, stringStatisticsLimit, dwrfEncryptors, metadataWriter));
                }
                return new StructColumnWriter(columnIndex, compressionParameters, dwrfEncryptor, (List<ColumnWriter>)fieldWriters.build(), metadataWriter);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }
}

