/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.cache;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.metadata.PostScript;
import com.google.common.base.Joiner;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class StorageOrcFileTailSource
implements OrcFileTailSource {
    private static final Logger log = Logger.get(StorageOrcFileTailSource.class);
    private static final int EXPECTED_FOOTER_SIZE = 16384;
    private static final int CURRENT_MAJOR_VERSION = 0;
    private static final int CURRENT_MINOR_VERSION = 12;

    @Override
    public OrcFileTail getOrcFileTail(OrcDataSource orcDataSource, MetadataReader metadataReader, Optional<OrcWriteValidation> writeValidation, boolean cacheable) throws IOException {
        Slice completeFooterSlice;
        PostScript postScript;
        long size = orcDataSource.getSize();
        if (size <= (long)PostScript.MAGIC.length()) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Invalid file size %s", size);
        }
        byte[] buffer = new byte[Math.toIntExact(Math.min(size, 16384L))];
        orcDataSource.readFully(size - (long)buffer.length, buffer);
        int postScriptSize = buffer[buffer.length - 1] & 0xFF;
        if (postScriptSize >= buffer.length) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Invalid postscript length %s", postScriptSize);
        }
        try {
            postScript = metadataReader.readPostScript(buffer, buffer.length - 1 - postScriptSize, postScriptSize);
        }
        catch (OrcCorruptionException e) {
            if (!StorageOrcFileTailSource.isValidHeaderMagic(orcDataSource)) {
                throw new OrcCorruptionException(orcDataSource.getId(), "Not an ORC file");
            }
            throw e;
        }
        StorageOrcFileTailSource.checkOrcVersion(orcDataSource, postScript.getVersion());
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getVersion().equals(postScript.getVersion()), "Unexpected version", new Object[0]);
        int bufferSize = Math.toIntExact(postScript.getCompressionBlockSize());
        CompressionKind compressionKind = postScript.getCompression();
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getCompression() == compressionKind, "Unexpected compression", new Object[0]);
        PostScript.HiveWriterVersion hiveWriterVersion = postScript.getHiveWriterVersion();
        int footerSize = Math.toIntExact(postScript.getFooterLength());
        int metadataSize = Math.toIntExact(postScript.getMetadataLength());
        int completeFooterSize = footerSize + metadataSize + postScriptSize + 1;
        if (completeFooterSize > buffer.length) {
            byte[] newBuffer = new byte[completeFooterSize];
            completeFooterSlice = Slices.wrappedBuffer((byte[])newBuffer);
            orcDataSource.readFully(size - (long)completeFooterSize, newBuffer, 0, completeFooterSize - buffer.length);
            completeFooterSlice.setBytes(completeFooterSize - buffer.length, buffer);
        } else {
            completeFooterSlice = Slices.wrappedBuffer((byte[])buffer, (int)(buffer.length - completeFooterSize), (int)completeFooterSize);
        }
        Slice metadataSlice = completeFooterSlice.slice(0, metadataSize);
        Slice footerSlice = completeFooterSlice.slice(metadataSize, footerSize);
        return new OrcFileTail(hiveWriterVersion, bufferSize, compressionKind, footerSlice, footerSize, metadataSlice, metadataSize);
    }

    private static boolean isValidHeaderMagic(OrcDataSource source) throws IOException {
        byte[] headerMagic = new byte[PostScript.MAGIC.length()];
        source.readFully(0L, headerMagic);
        return PostScript.MAGIC.equals((Object)Slices.wrappedBuffer((byte[])headerMagic));
    }

    private static void checkOrcVersion(OrcDataSource orcDataSource, List<Integer> version) {
        if (version.size() >= 1) {
            int major = version.get(0);
            int minor = 0;
            if (version.size() > 1) {
                minor = version.get(1);
            }
            if (major > 0 || major == 0 && minor > 12) {
                log.warn("ORC file %s was written by a newer Hive version %s. This file may not be readable by this version of Hive (%s.%s).", new Object[]{orcDataSource, Joiner.on((char)'.').join(version), 0, 12});
            }
        }
    }
}

