/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamV1;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class TimestampColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampColumnWriter.class).instanceSize();
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_TO_NANOS_TRAILING_ZEROS = 5;
    private final int column;
    private final Type type;
    private final boolean compressed;
    private final ColumnEncoding columnEncoding;
    private final LongOutputStream secondsStream;
    private final LongOutputStream nanosStream;
    private final PresentOutputStream presentStream;
    private final CompressedMetadataWriter metadataWriter;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private long columnStatisticsRetainedSizeInBytes;
    private final long baseTimestampInSeconds;
    private int nonNullValueCount;
    private boolean closed;

    public TimestampColumnWriter(int column, Type type, CompressionKind compression, Optional<DwrfDataEncryptor> dwrfEncryptor, int bufferSize, OrcEncoding orcEncoding, DateTimeZone hiveStorageTimeZone, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        this.column = column;
        this.type = Objects.requireNonNull(type, "type is null");
        boolean bl = this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        if (orcEncoding == OrcEncoding.DWRF) {
            this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
            this.secondsStream = new LongOutputStreamV1(compression, dwrfEncryptor, bufferSize, true, Stream.StreamKind.DATA);
            this.nanosStream = new LongOutputStreamV1(compression, dwrfEncryptor, bufferSize, false, Stream.StreamKind.SECONDARY);
        } else {
            this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
            this.secondsStream = new LongOutputStreamV2(compression, bufferSize, true, Stream.StreamKind.DATA);
            this.nanosStream = new LongOutputStreamV2(compression, bufferSize, false, Stream.StreamKind.SECONDARY);
        }
        this.presentStream = new PresentOutputStream(compression, dwrfEncryptor, bufferSize);
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, compression, dwrfEncryptor, bufferSize);
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.secondsStream.recordCheckpoint();
        this.nanosStream.recordCheckpoint();
    }

    @Override
    public void writeBlock(Block block) {
        int position;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        for (position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            long value = this.type.getLong(block, position);
            long seconds = value / 1000L - this.baseTimestampInSeconds;
            long millis = Math.floorMod(value, 1000L);
            long encodedNanos = millis == 0L ? 0L : millis << 3 | 5L;
            this.secondsStream.writeLong(seconds);
            this.nanosStream.writeLong(encodedNanos);
            ++this.nonNullValueCount;
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = new ColumnStatistics(Long.valueOf(this.nonNullValueCount), 0L, null, null, null, null, null, null, null, null);
        this.rowGroupColumnStatistics.add(statistics);
        this.columnStatisticsRetainedSizeInBytes += statistics.getRetainedSizeInBytes();
        this.nonNullValueCount = 0;
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.secondsStream.close();
        this.nanosStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List secondsCheckpoints = this.secondsStream.getCheckpoints();
        List nanosCheckpoints = this.nanosStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            LongStreamCheckpoint secondsCheckpoint = (LongStreamCheckpoint)secondsCheckpoints.get(groupId);
            LongStreamCheckpoint nanosCheckpoint = (LongStreamCheckpoint)nanosCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = TimestampColumnWriter.createTimestampColumnPositionList(this.compressed, secondsCheckpoint, nanosCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = this.metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.column, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    private static List<Integer> createTimestampColumnPositionList(boolean compressed, LongStreamCheckpoint secondsCheckpoint, LongStreamCheckpoint nanosCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(secondsCheckpoint.toPositionList(compressed));
        positionList.addAll(nanosCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.secondsStream.getStreamDataOutput(this.column));
        outputDataStreams.add((Object)this.nanosStream.getStreamDataOutput(this.column));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.secondsStream.getBufferedBytes() + this.nanosStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.secondsStream.getRetainedBytes() + this.nanosStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.secondsStream.reset();
        this.nanosStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.nonNullValueCount = 0;
    }
}

