/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamDwrfCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.LongDecode;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class LongOutputStreamDwrf
implements LongOutputStream {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongOutputStreamDwrf.class).instanceSize();
    private final Stream.StreamKind streamKind;
    private final OrcOutputBuffer buffer;
    private final boolean signed;
    private final List<LongStreamDwrfCheckpoint> checkpoints = new ArrayList<LongStreamDwrfCheckpoint>();
    private boolean closed;

    public LongOutputStreamDwrf(CompressionKind compression, Optional<DwrfDataEncryptor> dwrfEncryptor, int bufferSize, boolean signed, Stream.StreamKind streamKind) {
        this.streamKind = Objects.requireNonNull(streamKind, "streamKind is null");
        this.buffer = new OrcOutputBuffer(compression, dwrfEncryptor, bufferSize);
        this.signed = signed;
    }

    @Override
    public void writeLong(long value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        LongDecode.writeVLong(this.buffer, value, this.signed);
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new LongStreamDwrfCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.close();
    }

    @Override
    public List<LongStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(column, this.streamKind, Math.toIntExact(this.buffer.getOutputDataSize()), true));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

