/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BatchStreamReaders;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class StructBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StructBatchStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final Map<String, BatchStreamReader> structFields;
    private final RowType type;
    private final List<String> fieldNames;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;

    StructBatchStreamReader(Type type, StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone, OrcAggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, RowType.class::isInstance);
        this.type = (RowType)type;
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        ImmutableMap nestedStreams = Maps.uniqueIndex(streamDescriptor.getNestedStreams(), stream -> stream.getFieldName().toLowerCase(Locale.ENGLISH));
        ImmutableList.Builder fieldNames = ImmutableList.builder();
        ImmutableMap.Builder structFields = ImmutableMap.builder();
        for (RowType.Field field : this.type.getFields()) {
            String fieldName = ((String)field.getName().orElseThrow(() -> new IllegalArgumentException("ROW type does not have field names declared: " + type))).toLowerCase(Locale.ENGLISH);
            fieldNames.add((Object)fieldName);
            StreamDescriptor fieldStream = (StreamDescriptor)nestedStreams.get(fieldName);
            if (fieldStream == null) continue;
            structFields.put((Object)fieldName, (Object)BatchStreamReaders.createStreamReader(field.getType(), fieldStream, hiveStorageTimeZone, systemMemoryContext));
        }
        this.fieldNames = fieldNames.build();
        this.structFields = structFields.build();
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block[] blocks;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            for (BatchStreamReader structField : this.structFields.values()) {
                structField.prepareNextRead(this.readOffset);
            }
        }
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            blocks = this.getBlocksForType(this.nextBatchSize);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                blocks = this.getBlocksForType(this.nextBatchSize - nullValues);
            } else {
                List typeParameters = this.type.getTypeParameters();
                blocks = new Block[typeParameters.size()];
                for (int i = 0; i < typeParameters.size(); ++i) {
                    blocks[i] = ((Type)typeParameters.get(i)).createBlockBuilder(null, 0).build();
                }
            }
        }
        Verify.verify((Arrays.stream(blocks).mapToInt(Block::getPositionCount).distinct().count() == 1L ? 1 : 0) != 0);
        Block rowBlock = RowBlock.fromFieldBlocks((int)this.nextBatchSize, Optional.ofNullable(nullVector), (Block[])blocks);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return rowBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, Map<Integer, ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (BatchStreamReader structField : this.structFields.values()) {
            structField.startStripe(dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (BatchStreamReader structField : this.structFields.values()) {
            structField.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    private Block[] getBlocksForType(int positionCount) throws IOException {
        Block[] blocks = new Block[this.fieldNames.size()];
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String fieldName = this.fieldNames.get(i);
            BatchStreamReader streamReader = this.structFields.get(fieldName);
            if (streamReader != null) {
                streamReader.prepareNextRead(positionCount);
                blocks[i] = streamReader.readBlock();
                continue;
            }
            blocks[i] = RunLengthEncodedBlock.create((Type)((RowType.Field)this.type.getFields().get(i)).getType(), null, (int)positionCount);
        }
        return blocks;
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            for (BatchStreamReader batchStreamReader : this.structFields.values()) {
                closer.register(batchStreamReader::close);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (BatchStreamReader structField : this.structFields.values()) {
            retainedSizeInBytes += structField.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }
}

