/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.array.Arrays;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class MapFlatSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapFlatSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final boolean legacyMapSubscript;
    private final StreamDescriptor baseValueStreamDescriptor;
    private final OrcType.OrcTypeKind keyOrcTypeKind;
    private final DateTimeZone hiveStorageTimeZone;
    private final boolean nullsAllowed;
    private final boolean nonNullsAllowed;
    private final boolean outputRequired;
    @Nullable
    private final MapType outputType;
    @Nullable
    private final Set<Long> requiredLongKeys;
    @Nullable
    private final Set<String> requiredStringKeys;
    private int[] keyIndices;
    private int keyCount;
    private final List<InputStreamSource<BooleanInputStream>> inMapStreamSources = new ArrayList<InputStreamSource<BooleanInputStream>>();
    private final List<BooleanInputStream> inMapStreams = new ArrayList<BooleanInputStream>();
    private final List<SelectiveStreamReader> valueStreamReaders = new ArrayList<SelectiveStreamReader>();
    private final List<StreamDescriptor> valueStreamDescriptors = new ArrayList<StreamDescriptor>();
    private Block keyBlock;
    private int readOffset;
    private int[] nestedReadOffsets;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;
    private int[] offsets;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean outputPositionsReadOnly;
    private boolean allNulls;
    private boolean valuesInUse;
    private int[] nestedLengths;
    private int[][] nestedPositions;
    private int[] nestedPositionCounts;
    private int[][] nestedOutputPositions;
    private boolean[][] inMap;
    private final OrcAggregatedMemoryContext systemMemoryContext;
    private final OrcLocalMemoryContext localMemoryContext;

    public MapFlatSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> requiredSubfields, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, boolean legacyMapSubscript, OrcAggregatedMemoryContext systemMemoryContext) {
        Preconditions.checkArgument((boolean)filters.keySet().stream().map(Subfield::getPath).allMatch(List::isEmpty), (Object)"filters on nested columns are not supported yet");
        Preconditions.checkArgument((streamDescriptor.getNestedStreams().size() == 2 ? 1 : 0) != 0, (Object)"there must be exactly 2 nested stream descriptor");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.legacyMapSubscript = legacyMapSubscript;
        this.keyOrcTypeKind = streamDescriptor.getNestedStreams().get(0).getOrcTypeKind();
        this.baseValueStreamDescriptor = streamDescriptor.getNestedStreams().get(1);
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.localMemoryContext = systemMemoryContext.newOrcLocalMemoryContext(MapFlatSelectiveStreamReader.class.getSimpleName());
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.map(MapType.class::cast).orElse(null);
        TupleDomainFilter filter = MapFlatSelectiveStreamReader.getTopLevelFilter(filters).orElse(null);
        this.nullsAllowed = filter == null || filter.testNull();
        this.nonNullsAllowed = filter == null || filter.testNonNull();
        Objects.requireNonNull(requiredSubfields, "requiredSubfields is null");
        if (requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).anyMatch(Subfield.AllSubscripts.class::isInstance)) {
            this.requiredLongKeys = null;
            this.requiredStringKeys = null;
        } else {
            switch (this.keyOrcTypeKind) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    this.requiredLongKeys = (Set)requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.LongSubscript.class::cast).map(Subfield.LongSubscript::getIndex).collect(ImmutableSet.toImmutableSet());
                    this.requiredStringKeys = null;
                    return;
                }
                case STRING: 
                case BINARY: {
                    this.requiredStringKeys = (Set)requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.StringSubscript.class::cast).map(Subfield.StringSubscript::getIndex).collect(ImmutableSet.toImmutableSet());
                    this.requiredLongKeys = null;
                    return;
                }
            }
            this.requiredStringKeys = null;
            this.requiredLongKeys = null;
        }
    }

    private static Optional<TupleDomainFilter> getTopLevelFilter(Map<Subfield, TupleDomainFilter> filters) {
        Map topLevelFilters = Maps.filterEntries(filters, entry -> ((Subfield)entry.getKey()).getPath().isEmpty());
        if (topLevelFilters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((topLevelFilters.size() == 1 ? 1 : 0) != 0, (Object)"MAP column may have at most one top-level range filter");
        TupleDomainFilter filter = (TupleDomainFilter)Iterables.getOnlyElement(topLevelFilters.values());
        Preconditions.checkArgument((filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL ? 1 : 0) != 0, (Object)"Top-level range filter on MAP column must be IS NULL or IS NOT NULL");
        return Optional.of(filter);
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired && this.nullsAllowed && this.presentStream != null) {
            this.nulls = Arrays.ensureCapacity(this.nulls, positionCount);
        }
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        if (this.presentStream != null && this.keyCount == 0) {
            this.readAllNulls(positions, positionCount);
        } else {
            this.readNotAllNulls(offset, positions, positionCount);
        }
        this.localMemoryContext.setBytes(this.getRetainedSizeInBytes());
        return this.outputPositionCount;
    }

    private void readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        this.allNulls = true;
        if (!this.nullsAllowed) {
            this.outputPositionCount = 0;
        } else {
            this.outputPositionCount = positionCount;
            this.outputPositions = positions;
            this.outputPositionsReadOnly = true;
        }
    }

    private void readNotAllNulls(int offset, int[] positions, int positionCount) throws IOException {
        int position;
        int i;
        int streamPosition = 0;
        int[] nonNullPositions = new int[positionCount];
        int[] nullPositions = new int[positionCount];
        int nonNullPositionCount = 0;
        int nullPositionCount = 0;
        int nonNullSkipped = 0;
        if (this.presentStream == null) {
            if (this.readOffset < offset) {
                for (i = 0; i < this.keyCount; ++i) {
                    int n = i;
                    this.nestedReadOffsets[n] = this.nestedReadOffsets[n] + this.inMapStreams.get(i).countBitsSet(offset - this.readOffset);
                }
            }
            for (i = 0; i < positionCount; ++i) {
                position = positions[i];
                if (position > streamPosition) {
                    nonNullSkipped += position - streamPosition;
                    streamPosition = position;
                }
                nonNullPositions[i] = i + nonNullSkipped;
                ++streamPosition;
            }
            nonNullPositionCount = positionCount;
        } else {
            int skipped;
            if (this.readOffset < offset && (skipped = this.presentStream.countBitsSet(offset - this.readOffset)) > 0) {
                for (int i2 = 0; i2 < this.keyCount; ++i2) {
                    int n = i2;
                    this.nestedReadOffsets[n] = this.nestedReadOffsets[n] + this.inMapStreams.get(i2).countBitsSet(skipped);
                }
            }
            for (i = 0; i < positionCount; ++i) {
                position = positions[i];
                if (position > streamPosition) {
                    nonNullSkipped += this.presentStream.countBitsSet(position - streamPosition);
                    streamPosition = position;
                }
                ++streamPosition;
                if (this.presentStream.nextBit()) {
                    if (this.nullsAllowed) {
                        this.nulls[i] = false;
                    }
                    nonNullPositions[nonNullPositionCount] = nonNullPositionCount + nonNullSkipped;
                    ++nonNullPositionCount;
                    continue;
                }
                if (!this.nullsAllowed) continue;
                this.nulls[i] = true;
                nullPositions[nullPositionCount] = positions[i];
                ++nullPositionCount;
            }
        }
        this.readOffset = offset + streamPosition;
        if (!this.nonNullsAllowed) {
            Preconditions.checkState((nullPositionCount == positionCount - nonNullPositionCount ? 1 : 0) != 0, (Object)"nullPositionCount should be equal to postitionCount - nonNullPositionCount");
            this.outputPositionCount = nullPositionCount;
            this.allNulls = true;
            System.arraycopy(nullPositions, 0, this.outputPositions, 0, nullPositionCount);
        } else {
            this.nestedLengths = Arrays.ensureCapacity(this.nestedLengths, nonNullPositionCount);
            java.util.Arrays.fill(this.nestedLengths, 0);
            int keyIndex = 0;
            while (keyIndex < this.keyCount) {
                BooleanInputStream inMapStream = this.inMapStreams.get(keyIndex);
                this.nestedPositions[keyIndex] = Arrays.ensureCapacity(this.nestedPositions[keyIndex], nonNullPositionCount);
                this.inMap[keyIndex] = Arrays.ensureCapacity(this.inMap[keyIndex], nonNullPositionCount);
                int nestedStreamPosition = 0;
                int nestedSkipped = 0;
                int nestedPositionCount = 0;
                for (int i3 = 0; i3 < nonNullPositionCount; ++i3) {
                    int position2 = nonNullPositions[i3];
                    if (position2 > nestedStreamPosition) {
                        nestedSkipped += inMapStream.countBitsSet(position2 - nestedStreamPosition);
                        nestedStreamPosition = position2;
                    }
                    ++nestedStreamPosition;
                    if (inMapStream.nextBit()) {
                        this.nestedPositions[keyIndex][nestedPositionCount] = nestedPositionCount + nestedSkipped;
                        ++nestedPositionCount;
                        int n = i3;
                        this.nestedLengths[n] = this.nestedLengths[n] + 1;
                        this.inMap[keyIndex][i3] = true;
                        continue;
                    }
                    this.inMap[keyIndex][i3] = false;
                }
                if (nonNullSkipped > nestedStreamPosition - nonNullPositionCount) {
                    inMapStream.skip(nonNullSkipped - (nestedStreamPosition - nonNullPositionCount));
                }
                this.nestedPositionCounts[keyIndex] = nestedPositionCount;
                if (nestedPositionCount > 0) {
                    int readCount = this.valueStreamReaders.get(keyIndex).read(this.nestedReadOffsets[keyIndex], this.nestedPositions[keyIndex], nestedPositionCount);
                    Verify.verify((readCount == nestedPositionCount ? 1 : 0) != 0);
                }
                int n = keyIndex++;
                this.nestedReadOffsets[n] = this.nestedReadOffsets[n] + (nestedSkipped + nestedPositionCount);
            }
            if (this.nullsAllowed) {
                this.outputPositionCount = positionCount;
            } else {
                System.arraycopy(nonNullPositions, 0, this.outputPositions, 0, nonNullPositionCount);
                this.outputPositionCount = nonNullPositionCount;
            }
        }
        if (this.outputRequired) {
            this.nestedOutputPositions = Arrays.ensureCapacity(this.nestedOutputPositions, this.keyCount);
            for (i = 0; i < this.keyCount; ++i) {
                int nestedPositionCount = this.nestedPositionCounts[i];
                if (nestedPositionCount <= 0) continue;
                this.nestedOutputPositions[i] = Arrays.ensureCapacity(this.nestedOutputPositions[i], nestedPositionCount);
                System.arraycopy(this.nestedPositions[i], 0, this.nestedOutputPositions[i], 0, nestedPositionCount);
            }
        }
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        for (int i = 0; i < this.keyCount; ++i) {
            BooleanInputStream inMapStream = Objects.requireNonNull(this.inMapStreamSources.get(i).openStream(), "missing inMapStream at position " + i);
            this.inMapStreams.add(inMapStream);
        }
        this.rowGroupOpen = true;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return MapFlatSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (this.outputPositionCount != positionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        Block block = this.assembleMapBlock(includeNulls);
        this.nulls = null;
        this.offsets = null;
        return block;
    }

    private Block assembleMapBlock(boolean includeNulls) {
        int i;
        this.offsets = Arrays.ensureCapacity(this.offsets, this.outputPositionCount + 1);
        this.offsets[0] = 0;
        int offset = 0;
        int inMapIndex = 0;
        for (int i2 = 0; i2 < this.outputPositionCount; ++i2) {
            if (!includeNulls || !this.nulls[i2]) {
                offset += this.nestedLengths[inMapIndex];
                ++inMapIndex;
            }
            this.offsets[i2 + 1] = offset;
        }
        BlockLease[] valueBlockLeases = new BlockLease[this.keyCount];
        Block[] valueBlocks = new Block[this.keyCount];
        for (int i3 = 0; i3 < this.keyCount; ++i3) {
            if (this.nestedPositionCounts[i3] > 0) {
                valueBlockLeases[i3] = this.valueStreamReaders.get(i3).getBlockView(this.nestedOutputPositions[i3], this.nestedPositionCounts[i3]);
                valueBlocks[i3] = (Block)valueBlockLeases[i3].get();
                continue;
            }
            valueBlocks[i3] = this.outputType.getKeyType().createBlockBuilder(null, 0).build();
        }
        int[] keyIds = new int[offset];
        int count = 0;
        Type valueType = this.outputType.getValueType();
        BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, offset);
        int[] valueBlockPositions = new int[this.keyCount];
        inMapIndex = 0;
        for (i = 0; i < this.outputPositionCount; ++i) {
            if (includeNulls && this.nulls[i]) continue;
            for (int keyIndex = 0; keyIndex < this.keyCount; ++keyIndex) {
                if (!this.inMap[keyIndex][inMapIndex]) continue;
                valueType.appendTo(valueBlocks[keyIndex], valueBlockPositions[keyIndex], valueBlockBuilder);
                int n = keyIndex;
                valueBlockPositions[n] = valueBlockPositions[n] + 1;
                keyIds[count++] = keyIndex;
            }
            ++inMapIndex;
        }
        for (i = 0; i < this.keyCount; ++i) {
            if (valueBlockLeases[i] == null) continue;
            valueBlockLeases[i].close();
        }
        return this.outputType.createBlockFromKeyValue(this.outputPositionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.offsets, (Block)new DictionaryBlock(this.keyBlock, keyIds), (Block)valueBlockBuilder);
    }

    private static RunLengthEncodedBlock createNullBlock(Type type, int positionCount) {
        return new RunLengthEncodedBlock(type.createBlockBuilder(null, 1).appendNull().build(), positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)MapFlatSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount));
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        return this.newLease(this.assembleMapBlock(includeNulls));
    }

    private BlockLease newLease(Block block) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            this.valuesInUse = false;
        }});
    }

    private void compactValues(int[] positions, int positionCount, boolean includeNulls) {
        if (this.outputPositionsReadOnly) {
            this.outputPositions = java.util.Arrays.copyOf(this.outputPositions, this.outputPositionCount);
            this.outputPositionsReadOnly = false;
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int skipped = 0;
        int inMapSkipped = 0;
        int inMapIndex = 0;
        int[] nestedSkipped = new int[this.keyCount];
        int[] nestedIndex = new int[this.keyCount];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            int keyIndex;
            if (this.outputPositions[i] < nextPosition) {
                if (!includeNulls || !this.nulls[i]) {
                    for (keyIndex = 0; keyIndex < this.keyCount; ++keyIndex) {
                        if (!this.inMap[keyIndex][inMapIndex]) continue;
                        int n = keyIndex;
                        nestedSkipped[n] = nestedSkipped[n] + 1;
                        int n2 = keyIndex;
                        nestedIndex[n2] = nestedIndex[n2] + 1;
                    }
                    ++inMapSkipped;
                    ++inMapIndex;
                }
                ++skipped;
                continue;
            }
            this.outputPositions[i - skipped] = this.outputPositions[i];
            if (includeNulls) {
                this.nulls[i - skipped] = this.nulls[i];
            }
            if (!includeNulls || !this.nulls[i]) {
                this.nestedLengths[inMapIndex - inMapSkipped] = this.nestedLengths[inMapIndex];
                for (keyIndex = 0; keyIndex < this.keyCount; ++keyIndex) {
                    this.inMap[keyIndex][inMapIndex - inMapSkipped] = this.inMap[keyIndex][inMapIndex];
                    if (!this.inMap[keyIndex][inMapIndex]) continue;
                    this.nestedOutputPositions[keyIndex][nestedIndex[keyIndex] - nestedSkipped[keyIndex]] = this.nestedOutputPositions[keyIndex][nestedIndex[keyIndex]];
                    int n = keyIndex;
                    nestedIndex[n] = nestedIndex[n] + 1;
                }
                ++inMapIndex;
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
        for (int keyIndex = 0; keyIndex < this.keyCount; ++keyIndex) {
            this.nestedPositionCounts[keyIndex] = nestedIndex[keyIndex] - nestedSkipped[keyIndex];
        }
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    @Override
    public void close() {
        this.keyIndices = null;
        this.nestedReadOffsets = null;
        this.offsets = null;
        this.nulls = null;
        this.outputPositions = null;
        this.nestedLengths = null;
        this.nestedPositions = null;
        this.nestedPositionCounts = null;
        this.nestedOutputPositions = null;
        this.inMap = null;
        this.valueStreamReaders.stream().forEach(StreamReader::close);
        this.presentStream = null;
        this.presentStreamSource = null;
        this.localMemoryContext.close();
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, Map<Integer, ColumnEncoding> encodings) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.inMapStreamSources.clear();
        this.valueStreamDescriptors.clear();
        this.valueStreamReaders.clear();
        ColumnEncoding encoding = encodings.get(this.baseValueStreamDescriptor.getStreamId());
        SortedMap additionalSequenceEncodings = encoding.getAdditionalSequenceEncodings().orElse(Collections.emptySortedMap());
        this.keyIndices = Arrays.ensureCapacity(this.keyIndices, additionalSequenceEncodings.size());
        this.keyCount = 0;
        int keyIndex = 0;
        for (Map.Entry entry : additionalSequenceEncodings.entrySet()) {
            if (!this.isRequiredKey((DwrfSequenceEncoding)entry.getValue())) {
                ++keyIndex;
                continue;
            }
            this.keyIndices[this.keyCount] = keyIndex++;
            ++this.keyCount;
            int sequence = (Integer)entry.getKey();
            this.inMapStreamSources.add(MissingInputStreamSource.missingStreamSource(BooleanInputStream.class));
            StreamDescriptor valueStreamDescriptor = MapFlatSelectiveStreamReader.copyStreamDescriptorWithSequence(this.baseValueStreamDescriptor, sequence);
            this.valueStreamDescriptors.add(valueStreamDescriptor);
            SelectiveStreamReader valueStreamReader = SelectiveStreamReaders.createStreamReader(valueStreamDescriptor, (Map<Subfield, TupleDomainFilter>)ImmutableBiMap.of(), Optional.ofNullable(this.outputType).map(MapType::getValueType), (List<Subfield>)ImmutableList.of(), this.hiveStorageTimeZone, this.legacyMapSubscript, this.systemMemoryContext.newOrcAggregatedMemoryContext());
            valueStreamReader.startStripe(dictionaryStreamSources, encodings);
            this.valueStreamReaders.add(valueStreamReader);
        }
        this.keyBlock = this.getKeysBlock((List<DwrfSequenceEncoding>)ImmutableList.copyOf(additionalSequenceEncodings.values()));
        this.readOffset = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
    }

    private boolean isRequiredKey(DwrfSequenceEncoding value) {
        if (this.requiredLongKeys != null) {
            return this.requiredLongKeys.isEmpty() || this.requiredLongKeys.contains(value.getKey().getIntKey());
        }
        return this.requiredStringKeys.isEmpty() || this.requiredStringKeys.contains(value.getKey().getBytesKey().toStringUtf8());
    }

    private static StreamDescriptor copyStreamDescriptorWithSequence(StreamDescriptor streamDescriptor, int sequence) {
        List streamDescriptors = (List)streamDescriptor.getNestedStreams().stream().map(stream -> MapFlatSelectiveStreamReader.copyStreamDescriptorWithSequence(stream, sequence)).collect(ImmutableList.toImmutableList());
        return new StreamDescriptor(streamDescriptor.getStreamName(), streamDescriptor.getStreamId(), streamDescriptor.getFieldName(), streamDescriptor.getOrcType(), streamDescriptor.getOrcDataSource(), streamDescriptors, sequence);
    }

    private Block getKeysBlock(List<DwrfSequenceEncoding> sequenceEncodings) {
        switch (this.keyOrcTypeKind) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return this.getIntegerKeysBlock(sequenceEncodings);
            }
            case STRING: 
            case BINARY: {
                return this.getSliceKeysBlock(sequenceEncodings);
            }
        }
        throw new IllegalArgumentException("Unsupported flat map key type: " + (Object)((Object)this.keyOrcTypeKind));
    }

    private Block getIntegerKeysBlock(List<DwrfSequenceEncoding> sequenceEncodings) {
        TinyintType keyType;
        switch (this.keyOrcTypeKind) {
            case BYTE: {
                keyType = TinyintType.TINYINT;
                break;
            }
            case SHORT: {
                keyType = SmallintType.SMALLINT;
                break;
            }
            case INT: {
                keyType = IntegerType.INTEGER;
                break;
            }
            case LONG: {
                keyType = BigintType.BIGINT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported flat map key type: " + (Object)((Object)this.keyOrcTypeKind));
            }
        }
        BlockBuilder blockBuilder = keyType.createBlockBuilder(null, sequenceEncodings.size());
        for (int i = 0; i < this.keyCount; ++i) {
            keyType.writeLong(blockBuilder, sequenceEncodings.get(this.keyIndices[i]).getKey().getIntKey());
        }
        return blockBuilder.build();
    }

    private Block getSliceKeysBlock(List<DwrfSequenceEncoding> sequenceEncodings) {
        int bytes = 0;
        for (DwrfSequenceEncoding sequenceEncoding : sequenceEncodings) {
            bytes += sequenceEncoding.getKey().getBytesKey().size();
        }
        VariableWidthBlockBuilder builder = new VariableWidthBlockBuilder(null, sequenceEncodings.size(), bytes);
        for (int i = 0; i < this.keyCount; ++i) {
            Slice key = Slices.wrappedBuffer((byte[])sequenceEncodings.get(this.keyIndices[i]).getKey().getBytesKey().toByteArray());
            builder.writeBytes(key, 0, key.length());
            builder.closeEntry();
        }
        return builder.build();
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        for (int i = 0; i < this.keyCount; ++i) {
            InputStreamSource<BooleanInputStream> inMapStreamSource = dataStreamSources.getInputStreamSource(this.valueStreamDescriptors.get(i), Stream.StreamKind.IN_MAP, BooleanInputStream.class);
            this.inMapStreamSources.set(i, inMapStreamSource);
        }
        this.readOffset = 0;
        this.nestedReadOffsets = Arrays.ensureCapacity(this.nestedReadOffsets, this.keyCount);
        java.util.Arrays.fill(this.nestedReadOffsets, 0);
        this.nestedPositions = Arrays.ensureCapacity(this.nestedPositions, this.keyCount);
        this.nestedPositionCounts = Arrays.ensureCapacity(this.nestedPositionCounts, this.keyCount);
        this.inMap = Arrays.ensureCapacity(this.inMap, this.keyCount);
        this.presentStream = null;
        this.inMapStreams.clear();
        this.rowGroupOpen = false;
        for (SelectiveStreamReader valueStreamReader : this.valueStreamReaders) {
            valueStreamReader.startRowGroup(dataStreamSources);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.keyIndices) + SizeOf.sizeOf((int[])this.nestedReadOffsets) + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((int[])this.nestedLengths) + (this.nestedPositions != null ? java.util.Arrays.stream(this.nestedPositions).mapToLong(SizeOf::sizeOf).sum() : 0L) + SizeOf.sizeOf((int[])this.nestedPositionCounts) + (this.nestedOutputPositions != null ? java.util.Arrays.stream(this.nestedOutputPositions).mapToLong(SizeOf::sizeOf).sum() : 0L) + (this.inMap != null ? java.util.Arrays.stream(this.inMap).mapToLong(SizeOf::sizeOf).sum() : 0L) + (this.valueStreamReaders != null ? this.valueStreamReaders.stream().mapToLong(StreamReader::getRetainedSizeInBytes).sum() : 0L);
    }
}

