/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.array.Arrays;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.AbstractLongSelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongDictionarySelectiveStreamReader
extends AbstractLongSelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongDictionarySelectiveStreamReader.class).instanceSize();
    private static final byte FILTER_NOT_EVALUATED = 0;
    private static final byte FILTER_PASSED = 1;
    private static final byte FILTER_FAILED = 2;
    private final StreamDescriptor streamDescriptor;
    @Nullable
    private final TupleDomainFilter filter;
    private final boolean nonDeterministicFilter;
    private final boolean nullsAllowed;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> dictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private int dictionarySize;
    private long[] dictionary = new long[0];
    private byte[] dictionaryFilterStatus;
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream inDictionaryStream;
    private InputStreamSource<LongInputStream> dataStreamSource;
    @Nullable
    private LongInputStream dataStream;
    private boolean dictionaryOpen;
    private boolean rowGroupOpen;
    private int readOffset;
    private OrcLocalMemoryContext systemMemoryContext;

    public LongDictionarySelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, OrcLocalMemoryContext systemMemoryContext) {
        super(outputType);
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((filter.isPresent() || this.outputRequired ? 1 : 0) != 0, (Object)"filter must be present if output is not required");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = filter.orElse(null);
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0, (Object)"positionCount must be greater than zero");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.prepareNextRead(positionCount, this.presentStream != null && this.nullsAllowed);
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int streamPosition = this.filter == null ? this.readNoFilter(positions, positionCount) : this.readWithFilter(positions, positionCount);
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
                this.values[i] = 0L;
            } else {
                long value = this.dataStream.next();
                if (this.inDictionaryStream == null || this.inDictionaryStream.nextBit()) {
                    value = this.dictionary[(int)value];
                }
                this.values[i] = value;
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount) throws IOException {
        this.outputPositionCount = 0;
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                        this.values[this.outputPositionCount] = 0L;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                boolean filterPassed;
                long value = this.dataStream.next();
                if (this.inDictionaryStream == null || this.inDictionaryStream.nextBit()) {
                    int id = (int)value;
                    value = this.dictionary[id];
                    if (!this.nonDeterministicFilter) {
                        if (this.dictionaryFilterStatus[id] == 0) {
                            this.dictionaryFilterStatus[id] = this.filter.testLong(value) ? 1 : 2;
                        }
                        filterPassed = this.dictionaryFilterStatus[id] == 1;
                    } else {
                        filterPassed = this.filter.testLong(value);
                    }
                } else {
                    filterPassed = this.filter.testLong(value);
                }
                if (filterPassed) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = value;
                        if (this.presentStream != null && this.nullsAllowed) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            }
            ++streamPosition;
            this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
            int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            this.skip(positionsToSkip);
        }
        return streamPosition;
    }

    private void skip(int items) throws IOException {
        if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(dataToSkip);
            }
            if (this.dataStream != null) {
                this.dataStream.skip(dataToSkip);
            }
        } else {
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(items);
            }
            this.dataStream.skip(items);
        }
    }

    private void openRowGroup() throws IOException {
        if (!this.dictionaryOpen && this.dictionarySize > 0) {
            LongInputStream dictionaryStream;
            if (this.dictionary.length < this.dictionarySize) {
                this.dictionary = new long[this.dictionarySize];
            }
            if ((dictionaryStream = this.dictionaryDataStreamSource.openStream()) == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but data stream is not present");
            }
            dictionaryStream.nextLongVector(this.dictionarySize, this.dictionary);
            if (this.filter != null && !this.nonDeterministicFilter) {
                this.dictionaryFilterStatus = Arrays.ensureCapacity(this.dictionaryFilterStatus, this.dictionarySize);
                java.util.Arrays.fill(this.dictionaryFilterStatus, 0, this.dictionarySize, (byte)0);
            }
        }
        this.dictionaryOpen = true;
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        return this.buildOutputBlock(positions, positionCount, this.nullsAllowed && this.presentStream != null);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        return this.buildOutputBlockView(positions, positionCount, this.nullsAllowed && this.presentStream != null);
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, Map<Integer, ColumnEncoding> encoding) {
        this.dictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, LongInputStream.class);
        this.dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncoding(this.streamDescriptor.getSequence()).getDictionarySize();
        this.dictionaryOpen = false;
        this.inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.values = null;
        this.nulls = null;
        this.outputPositions = null;
        this.dictionary = null;
        this.dictionaryFilterStatus = null;
        this.dataStreamSource = null;
        this.dataStream = null;
        this.dictionaryDataStreamSource = null;
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.dictionary) + SizeOf.sizeOf((byte[])this.dictionaryFilterStatus) + SizeOf.sizeOf((long[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }
}

