/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.DecimalInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class DecimalBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalBatchStreamReader.class).instanceSize();
    private final DecimalType type;
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<DecimalInputStream> decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
    @Nullable
    private DecimalInputStream decimalStream;
    private InputStreamSource<LongInputStream> scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream scaleStream;
    private boolean rowGroupOpen;

    public DecimalBatchStreamReader(Type type, StreamDescriptor streamDescriptor) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, DecimalType.class::isInstance);
        this.type = (DecimalType)type;
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.seekToOffset();
        if (this.decimalStream == null && this.scaleStream == null && this.presentStream != null) {
            this.presentStream.skip(this.nextBatchSize);
            Block nullValueBlock = RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize);
            this.readOffset = 0;
            this.nextBatchSize = 0;
            return nullValueBlock;
        }
        BlockBuilder builder = this.type.createBlockBuilder(null, this.nextBatchSize);
        if (this.presentStream == null) {
            if (this.decimalStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but decimal stream is not present");
            }
            if (this.scaleStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but scale stream is not present");
            }
            for (int i = 0; i < this.nextBatchSize; ++i) {
                long sourceScale = this.scaleStream.next();
                if (this.type.isShort()) {
                    long rescaledDecimal = Decimals.rescale((long)this.decimalStream.nextLong(), (int)((int)sourceScale), (int)this.type.getScale());
                    this.type.writeLong(builder, rescaledDecimal);
                    continue;
                }
                Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                this.decimalStream.nextLongDecimal(decimal);
                UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)((int)((long)this.type.getScale() - sourceScale)), (Slice)rescaledDecimal);
                this.type.writeSlice(builder, rescaledDecimal);
            }
        } else {
            Verify.verify((this.decimalStream != null ? 1 : 0) != 0);
            Verify.verify((this.scaleStream != null ? 1 : 0) != 0);
            for (int i = 0; i < this.nextBatchSize; ++i) {
                if (this.presentStream.nextBit()) {
                    long sourceScale = this.scaleStream.next();
                    if (this.type.isShort()) {
                        long rescaledDecimal = Decimals.rescale((long)this.decimalStream.nextLong(), (int)((int)sourceScale), (int)this.type.getScale());
                        this.type.writeLong(builder, rescaledDecimal);
                        continue;
                    }
                    Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                    Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                    this.decimalStream.nextLongDecimal(decimal);
                    UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)((int)((long)this.type.getScale() - sourceScale)), (Slice)rescaledDecimal);
                    this.type.writeSlice(builder, rescaledDecimal);
                    continue;
                }
                builder.appendNull();
            }
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return builder.build();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.decimalStream = this.decimalStreamSource.openStream();
        this.scaleStream = this.scaleStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private void seekToOffset() throws IOException {
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.decimalStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but decimal stream is not present");
                }
                if (this.scaleStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but scale stream is not present");
                }
                this.decimalStream.skip(this.readOffset);
                this.scaleStream.skip(this.readOffset);
            }
        }
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, Map<Integer, ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
        this.scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.decimalStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, DecimalInputStream.class);
        this.scaleStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

