/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import io.airlift.units.DataSize;
import java.util.Objects;

public class OrcReaderOptions {
    private final DataSize maxMergeDistance;
    private final DataSize tinyStripeThreshold;
    private final DataSize maxBlockSize;
    private final boolean zstdJniDecompressionEnabled;

    public OrcReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean zstdJniDecompressionEnabled) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public boolean isOrcZstdJniDecompressionEnabled() {
        return this.zstdJniDecompressionEnabled;
    }

    public DataSize getTinyStripeThreshold() {
        return this.tinyStripeThreshold;
    }
}

