/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.CachingOrcDataSource;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.FilterFunction;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfEncryption;
import com.facebook.presto.orc.metadata.EncryptionGroup;
import com.facebook.presto.orc.metadata.ExceptionWrappingMetadataReader;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.joda.time.DateTimeZone;

public class OrcReader {
    public static final int MAX_BATCH_SIZE = 1024;
    public static final int INITIAL_BATCH_SIZE = 1;
    public static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final OrcDataSource orcDataSource;
    private final ExceptionWrappingMetadataReader metadataReader;
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final int bufferSize;
    private final CompressionKind compressionKind;
    private final Optional<OrcDecompressor> decompressor;
    private final Optional<EncryptionLibrary> encryptionLibrary;
    private final Map<Integer, Integer> dwrfEncryptionGroupMap;
    private final Footer footer;
    private final Metadata metadata;
    private final Optional<OrcWriteValidation> writeValidation;
    private final StripeMetadataSource stripeMetadataSource;
    private final OrcReaderOptions orcReaderOptions;
    private final boolean cacheable;

    public OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource, OrcAggregatedMemoryContext aggregatedMemoryContext, OrcReaderOptions orcReaderOptions, boolean cacheable, DwrfEncryptionProvider dwrfEncryptionProvider) throws IOException {
        this(orcDataSource, orcEncoding, orcFileTailSource, stripeMetadataSource, Optional.empty(), aggregatedMemoryContext, orcReaderOptions, cacheable, dwrfEncryptionProvider);
    }

    OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource, Optional<OrcWriteValidation> writeValidation, OrcAggregatedMemoryContext aggregatedMemoryContext, OrcReaderOptions orcReaderOptions, boolean cacheable, DwrfEncryptionProvider dwrfEncryptionProvider) throws IOException {
        this.orcReaderOptions = Objects.requireNonNull(orcReaderOptions, "orcReaderOptions is null");
        this.orcDataSource = orcDataSource = OrcReader.wrapWithCacheIfTiny(orcDataSource, orcReaderOptions.getTinyStripeThreshold());
        Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        this.metadataReader = new ExceptionWrappingMetadataReader(orcDataSource.getId(), orcEncoding.createMetadataReader());
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.stripeMetadataSource = Objects.requireNonNull(stripeMetadataSource, "stripeMetadataSource is null");
        OrcFileTail orcFileTail = orcFileTailSource.getOrcFileTail(orcDataSource, this.metadataReader, writeValidation, cacheable);
        this.bufferSize = orcFileTail.getBufferSize();
        this.compressionKind = orcFileTail.getCompressionKind();
        this.decompressor = OrcDecompressor.createOrcDecompressor(orcDataSource.getId(), this.compressionKind, this.bufferSize, orcReaderOptions.isOrcZstdJniDecompressionEnabled());
        this.hiveWriterVersion = orcFileTail.getHiveWriterVersion();
        try (OrcInputStream footerInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)orcFileTail.getFooterSlice().getInput(), this.decompressor, Optional.empty(), aggregatedMemoryContext, orcFileTail.getFooterSize());){
            this.footer = this.metadataReader.readFooter(this.hiveWriterVersion, footerInputStream);
        }
        if (this.footer.getTypes().size() == 0) {
            throw new OrcCorruptionException(orcDataSource.getId(), "File has no columns");
        }
        OrcReader.validateEncryption(this.footer, this.orcDataSource.getId());
        Optional<DwrfEncryption> encryption = this.footer.getEncryption();
        if (encryption.isPresent()) {
            this.dwrfEncryptionGroupMap = DwrfEncryptionInfo.createNodeToGroupMap((List)encryption.get().getEncryptionGroups().stream().map(EncryptionGroup::getNodes).collect(ImmutableList.toImmutableList()), this.footer.getTypes());
            this.encryptionLibrary = Optional.of(dwrfEncryptionProvider.getEncryptionLibrary(encryption.get().getKeyProvider()));
        } else {
            this.dwrfEncryptionGroupMap = ImmutableMap.of();
            this.encryptionLibrary = Optional.empty();
        }
        try (OrcInputStream metadataInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)orcFileTail.getMetadataSlice().getInput(), this.decompressor, Optional.empty(), aggregatedMemoryContext, orcFileTail.getMetadataSize());){
            this.metadata = this.metadataReader.readMetadata(this.hiveWriterVersion, metadataInputStream);
        }
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getColumnNames().equals(this.footer.getTypes().get(0).getFieldNames()), "Unexpected column names", new Object[0]);
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getRowGroupMaxRowCount() == this.footer.getRowsInRowGroup(), "Unexpected rows in group", new Object[0]);
        if (writeValidation.isPresent()) {
            writeValidation.get().validateMetadata(orcDataSource.getId(), this.footer.getUserMetadata());
            writeValidation.get().validateFileStatistics(orcDataSource.getId(), this.footer.getFileStats());
            writeValidation.get().validateStripeStatistics(orcDataSource.getId(), this.footer.getStripes(), this.metadata.getStripeStatsList());
        }
        this.cacheable = Objects.requireNonNull(Boolean.valueOf(cacheable), "hiveFileContext is null");
    }

    @VisibleForTesting
    public static void validateEncryption(Footer footer, OrcDataSourceId dataSourceId) {
        if (!footer.getEncryption().isPresent()) {
            return;
        }
        footer.getEncryption().get();
        DwrfEncryption dwrfEncryption = footer.getEncryption().get();
        int encryptionGroupSize = dwrfEncryption.getEncryptionGroups().size();
        List<StripeInformation> stripes = footer.getStripes();
        if (!stripes.isEmpty() && encryptionGroupSize > 0 && stripes.get(0).getKeyMetadata().isEmpty()) {
            throw new OrcCorruptionException(dataSourceId, "Stripe encryption keys are missing, but file is encrypted");
        }
        for (StripeInformation stripe : stripes) {
            if (stripe.getKeyMetadata().isEmpty() || stripe.getKeyMetadata().size() == encryptionGroupSize) continue;
            throw new OrcCorruptionException(dataSourceId, "Number of stripe encryption keys did not match number of encryption groups.  Expected %s, but found %s", encryptionGroupSize, stripe.getKeyMetadata().size());
        }
    }

    public List<String> getColumnNames() {
        return this.footer.getTypes().get(0).getFieldNames();
    }

    public List<OrcType> getTypes() {
        return this.footer.getTypes();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OrcBatchRecordReader createBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, DateTimeZone hiveStorageTimeZone, OrcAggregatedMemoryContext systemMemoryUsage, int initialBatchSize, Map<Integer, Slice> columnsToIntermediateKeys) throws OrcCorruptionException {
        return this.createBatchRecordReader(includedColumns, predicate, 0L, this.orcDataSource.getSize(), hiveStorageTimeZone, systemMemoryUsage, initialBatchSize, columnsToIntermediateKeys);
    }

    public OrcBatchRecordReader createBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, OrcAggregatedMemoryContext systemMemoryUsage, int initialBatchSize, Map<Integer, Slice> columnsToIntermediateKeys) throws OrcCorruptionException {
        return new OrcBatchRecordReader(Objects.requireNonNull(includedColumns, "includedColumns is null"), Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.encryptionLibrary, this.dwrfEncryptionGroupMap, columnsToIntermediateKeys, this.footer.getRowsInRowGroup(), Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null"), this.hiveWriterVersion, this.metadataReader, this.orcReaderOptions.getMaxMergeDistance(), this.orcReaderOptions.getTinyStripeThreshold(), this.orcReaderOptions.getMaxBlockSize(), this.footer.getUserMetadata(), systemMemoryUsage.newOrcAggregatedMemoryContext(), this.writeValidation, initialBatchSize, this.stripeMetadataSource, this.cacheable);
    }

    public OrcSelectiveRecordReader createSelectiveRecordReader(Map<Integer, Type> includedColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputs, Map<Integer, List<Subfield>> requiredSubfields, Map<Integer, Object> constantValues, Map<Integer, Function<Block, Block>> coercers, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, boolean legacyMapSubscript, OrcAggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, Map<Integer, Slice> columnsToIntermediateKeys) {
        return new OrcSelectiveRecordReader(includedColumns, outputColumns, filters, filterFunctions, filterFunctionInputs, requiredSubfields, constantValues, coercers, predicate, this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.encryptionLibrary, this.dwrfEncryptionGroupMap, columnsToIntermediateKeys, this.footer.getRowsInRowGroup(), hiveStorageTimeZone, legacyMapSubscript, this.hiveWriterVersion, this.metadataReader, this.orcReaderOptions.getMaxMergeDistance(), this.orcReaderOptions.getTinyStripeThreshold(), this.orcReaderOptions.getMaxBlockSize(), this.footer.getUserMetadata(), systemMemoryUsage.newOrcAggregatedMemoryContext(), writeValidation, initialBatchSize, this.stripeMetadataSource, this.cacheable);
    }

    private static OrcDataSource wrapWithCacheIfTiny(OrcDataSource dataSource, DataSize maxCacheSize) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        if (dataSource.getSize() > maxCacheSize.toBytes()) {
            return dataSource;
        }
        DiskRange diskRange = new DiskRange(0L, Math.toIntExact(dataSource.getSize()));
        return new CachingOrcDataSource(dataSource, desiredOffset -> diskRange);
    }

    static void validateFile(OrcWriteValidation writeValidation, OrcDataSource input, List<Type> types, DateTimeZone hiveStorageTimeZone, OrcEncoding orcEncoding, OrcReaderOptions orcReaderOptions, Map<Integer, Slice> columnsToKeyMetadata, DwrfEncryptionProvider dwrfEncryptionProvider) throws OrcCorruptionException {
        ImmutableMap.Builder readTypes = ImmutableMap.builder();
        for (int columnIndex = 0; columnIndex < types.size(); ++columnIndex) {
            readTypes.put((Object)columnIndex, (Object)types.get(columnIndex));
        }
        try {
            OrcReader orcReader = new OrcReader(input, orcEncoding, new StorageOrcFileTailSource(), new StorageStripeMetadataSource(), Optional.of(writeValidation), NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, orcReaderOptions, false, dwrfEncryptionProvider);
            try (OrcBatchRecordReader orcRecordReader = orcReader.createBatchRecordReader((Map<Integer, Type>)readTypes.build(), OrcPredicate.TRUE, hiveStorageTimeZone, NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, 1, columnsToKeyMetadata);){
                while (orcRecordReader.nextBatch() >= 0) {
                }
            }
        }
        catch (IOException e) {
            throw new OrcCorruptionException(e, input.getId(), "Validation failed", new Object[0]);
        }
    }

    public static void validateWrite(Optional<OrcWriteValidation> writeValidation, OrcDataSource orcDataSource, Predicate<OrcWriteValidation> test, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (writeValidation.isPresent() && !test.test(writeValidation.get())) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }
}

