/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BatchStreamReaders;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class MapDirectBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapDirectBatchStreamReader.class).instanceSize();
    private final MapType type;
    private final StreamDescriptor streamDescriptor;
    private final BatchStreamReader keyStreamReader;
    private final BatchStreamReader valueStreamReader;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;

    public MapDirectBatchStreamReader(Type type, StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone, OrcAggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, MapType.class::isInstance);
        this.type = (MapType)type;
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.keyStreamReader = BatchStreamReaders.createStreamReader(this.type.getKeyType(), streamDescriptor.getNestedStreams().get(0), hiveStorageTimeZone, systemMemoryContext);
        this.valueStreamReader = BatchStreamReaders.createStreamReader(this.type.getValueType(), streamDescriptor.getNestedStreams().get(1), hiveStorageTimeZone, systemMemoryContext);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block values;
        Block keys;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                long entrySkipSize = this.lengthStream.sum(this.readOffset);
                this.keyStreamReader.prepareNextRead(Math.toIntExact(entrySkipSize));
                this.valueStreamReader.prepareNextRead(Math.toIntExact(entrySkipSize));
            }
        }
        int[] offsetVector = new int[this.nextBatchSize + 1];
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            this.lengthStream.next(offsetVector, this.nextBatchSize);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.lengthStream.next(offsetVector, this.nextBatchSize - nullValues);
                ReaderUtils.unpackLengthNulls(offsetVector, nullVector, this.nextBatchSize - nullValues);
            }
        }
        MapType mapType = this.type;
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        int entryCount = 0;
        for (int i = 0; i < offsetVector.length - 1; ++i) {
            entryCount += offsetVector[i];
        }
        if (entryCount > 0) {
            this.keyStreamReader.prepareNextRead(entryCount);
            this.valueStreamReader.prepareNextRead(entryCount);
            keys = this.keyStreamReader.readBlock();
            values = this.valueStreamReader.readBlock();
        } else {
            keys = keyType.createBlockBuilder(null, 0).build();
            values = valueType.createBlockBuilder(null, 1).build();
        }
        Block[] keyValueBlock = MapDirectBatchStreamReader.createKeyValueBlock(this.nextBatchSize, keys, values, offsetVector);
        ReaderUtils.convertLengthVectorToOffsetVector(offsetVector);
        Block block = mapType.createBlockFromKeyValue(this.nextBatchSize, Optional.ofNullable(nullVector), offsetVector, keyValueBlock[0], keyValueBlock[1]);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private static Block[] createKeyValueBlock(int positionCount, Block keys, Block values, int[] lengths) {
        if (!MapDirectBatchStreamReader.hasNull(keys)) {
            return new Block[]{keys, values};
        }
        IntArrayList nonNullPositions = new IntArrayList(keys.getPositionCount());
        int position = 0;
        for (int mapIndex = 0; mapIndex < positionCount; ++mapIndex) {
            int length = lengths[mapIndex];
            for (int entryIndex = 0; entryIndex < length; ++entryIndex) {
                if (keys.isNull(position)) {
                    int n = mapIndex;
                    lengths[n] = lengths[n] - 1;
                } else {
                    nonNullPositions.add(position);
                }
                ++position;
            }
        }
        Block newKeys = keys.copyPositions(nonNullPositions.elements(), 0, nonNullPositions.size());
        Block newValues = values.copyPositions(nonNullPositions.elements(), 0, nonNullPositions.size());
        return new Block[]{newKeys, newValues};
    }

    private static boolean hasNull(Block keys) {
        for (int position = 0; position < keys.getPositionCount(); ++position) {
            if (!keys.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startStripe(dictionaryStreamSources, encoding);
        this.valueStreamReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startRowGroup(dataStreamSources);
        this.valueStreamReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.keyStreamReader::close);
            closer.register(this.valueStreamReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyStreamReader.getRetainedSizeInBytes() + this.valueStreamReader.getRetainedSizeInBytes();
    }
}

