/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.array.Arrays;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class BooleanSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanSelectiveStreamReader.class).instanceSize();
    private static final Block NULL_BLOCK = BooleanType.BOOLEAN.createBlockBuilder(null, 1).appendNull().build();
    private final StreamDescriptor streamDescriptor;
    @Nullable
    private final TupleDomainFilter filter;
    private final boolean nonDeterministicFilter;
    private final boolean nullsAllowed;
    private final boolean outputRequired;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<BooleanInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream dataStream;
    private boolean rowGroupOpen;
    private int readOffset;
    @Nullable
    private byte[] values;
    @Nullable
    private boolean[] nulls;
    @Nullable
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private boolean valuesInUse;
    private OrcLocalMemoryContext systemMemoryContext;

    public BooleanSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, boolean outputRequired, OrcLocalMemoryContext systemMemoryContext) {
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((filter.isPresent() || outputRequired ? 1 : 0) != 0, (Object)"filter must be present if outputRequired is false");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.filter = filter.orElse(null);
        this.outputRequired = outputRequired;
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, BooleanInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0, (Object)"positionCount must be greater than zero");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int streamPosition = 0;
        if (this.dataStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
        } else if (this.filter == null) {
            streamPosition = this.readNoFilter(positions, positionCount);
        } else {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (position > streamPosition) {
                    this.skip(position - streamPosition);
                    streamPosition = position;
                }
                if (this.presentStream != null && !this.presentStream.nextBit()) {
                    if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                        if (this.outputRequired) {
                            this.nulls[this.outputPositionCount] = true;
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                } else {
                    boolean value = this.dataStream.nextBit();
                    if (this.filter.testBoolean(value)) {
                        if (this.outputRequired) {
                            this.values[this.outputPositionCount] = (byte)(value ? 1 : 0);
                            if (this.nullsAllowed && this.presentStream != null) {
                                this.nulls[this.outputPositionCount] = false;
                            }
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                }
                this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
                ++streamPosition;
                int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
                if (succeedingPositionsToFail <= 0) continue;
                int positionsToSkip = 0;
                for (int j = 0; j < succeedingPositionsToFail; ++j) {
                    int nextPosition = positions[++i];
                    positionsToSkip += 1 + nextPosition - streamPosition;
                    streamPosition = nextPosition + 1;
                }
                this.skip(positionsToSkip);
            }
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nonDeterministicFilter) {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                if (this.filter.testNull()) {
                    ++this.outputPositionCount;
                    continue;
                }
                this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
                i += this.filter.getSucceedingPositionsToFail();
            }
        } else {
            this.outputPositionCount = this.nullsAllowed ? positionCount : 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        if (this.presentStream == null && positions[positionCount - 1] == positionCount - 1) {
            this.dataStream.getSetBits(positionCount, this.values);
            this.outputPositionCount = positionCount;
            return positionCount;
        }
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
            } else {
                this.values[i] = (byte)(this.dataStream.nextBit() ? 1 : 0);
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(dataToSkip);
        } else {
            this.dataStream.skip(items);
        }
    }

    private void ensureValuesCapacity(int capacity, boolean recordNulls) {
        this.values = Arrays.ensureCapacity(this.values, capacity);
        if (recordNulls) {
            this.nulls = Arrays.ensureCapacity(this.nulls, capacity);
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(NULL_BLOCK, positionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount == this.outputPositionCount) {
            ByteArrayBlock block = new ByteArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.values);
            this.nulls = null;
            this.values = null;
            return block;
        }
        byte[] valuesCopy = new byte[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            valuesCopy[positionIndex] = this.values[i];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new ByteArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)new RunLengthEncodedBlock(NULL_BLOCK, positionCount));
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        return this.newLease((Block)new ByteArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.values));
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    private BlockLease newLease(Block block) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            this.valuesInUse = false;
        }});
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            this.values[positionIndex] = this.values[i];
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    public void close() {
        this.values = null;
        this.outputPositions = null;
        this.nulls = null;
        this.presentStream = null;
        this.presentStreamSource = null;
        this.dataStream = null;
        this.dataStreamSource = null;
        this.systemMemoryContext.close();
    }
}

